/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import jakarta.persistence.PersistenceUnitTransactionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PersistenceContentHandler
implements ContentHandler {
    private static final String NS_URI = "https://jakarta.ee/xml/ns/persistence";
    private static final String NAMESPACE_URI = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final String NAMESPACE_URI_OLD = "http://java.sun.com/xml/ns/persistence";
    private static final String ELEMENT_PERSISTENCE = "persistence";
    private static final String ELEMENT_PERSISTENCE_UNIT = "persistence-unit";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ELEMENT_QUALIFIER = "qualifier";
    private static final String ELEMENT_SCOPE = "scope";
    private static final String ELEMENT_JTA_DATA_SOURCE = "jta-data-source";
    private static final String ELEMENT_NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String ELEMENT_MAPPING_FILE = "mapping-file";
    private static final String ELEMENT_JAR_FILE = "jar-file";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String ELEMENT_CACHING = "shared-cache-mode";
    private static final String ELEMENT_VALIDATION_MODE = "validation-mode";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_TRANSACTION_TYPE = "transaction-type";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ELEMENT_PROPERTIES = "properties";
    private static final String ELEMENT_DESCRIPTION = "description";
    private SEPersistenceUnitInfo persistenceUnitInfo;
    private List<SEPersistenceUnitInfo> persistenceUnits;
    private StringBuilder stringBuilder = new StringBuilder();
    private String version;
    private boolean readCharacters = false;

    public PersistenceContentHandler() {
        this.persistenceUnits = new ArrayList<SEPersistenceUnitInfo>();
    }

    public List<SEPersistenceUnitInfo> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (NS_URI.equals(namespaceURI) || NAMESPACE_URI.equals(namespaceURI) || NAMESPACE_URI_OLD.equals(namespaceURI)) {
            if (ELEMENT_PERSISTENCE_UNIT.equals(localName)) {
                this.persistenceUnitInfo = new SEPersistenceUnitInfo();
                this.persistenceUnitInfo.setPersistenceXMLSchemaVersion(this.version);
                this.persistenceUnitInfo.setPersistenceUnitName(attrs.getValue(ATTRIBUTE_NAME));
                String transactionType = attrs.getValue(ATTRIBUTE_TRANSACTION_TYPE);
                if (transactionType != null) {
                    try {
                        this.persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)transactionType));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SAXParseException("Unsupported value '%s' in %s attribute".formatted(transactionType, ATTRIBUTE_TRANSACTION_TYPE), null, iae);
                    }
                }
            } else if (ELEMENT_PROPERTY.equals(localName)) {
                this.persistenceUnitInfo.getProperties().setProperty(attrs.getValue(ATTRIBUTE_NAME), attrs.getValue(ATTRIBUTE_VALUE));
            } else if (ELEMENT_PERSISTENCE.equals(localName)) {
                this.version = attrs.getValue(ATTRIBUTE_VERSION);
            } else {
                this.readCharacters = true;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (NS_URI.equals(namespaceURI) || NAMESPACE_URI.equals(namespaceURI) || NAMESPACE_URI_OLD.equals(namespaceURI)) {
            String content = this.stringBuilder.toString().trim();
            this.stringBuilder.delete(0, this.stringBuilder.length());
            this.readCharacters = false;
            switch (localName) {
                case "provider": {
                    this.persistenceUnitInfo.setPersistenceProviderClassName(content);
                    break;
                }
                case "jta-data-source": {
                    this.persistenceUnitInfo.setJtaDataSource(new DataSourceImpl(content, null, null, null));
                    break;
                }
                case "non-jta-data-source": {
                    this.persistenceUnitInfo.setNonJtaDataSource(new DataSourceImpl(content, null, null, null));
                    break;
                }
                case "mapping-file": {
                    this.persistenceUnitInfo.getMappingFileNames().add(content);
                    break;
                }
                case "jar-file": {
                    this.persistenceUnitInfo.getJarFiles().add(content);
                    break;
                }
                case "class": {
                    this.persistenceUnitInfo.getManagedClassNames().add(content);
                    break;
                }
                case "exclude-unlisted-classes": {
                    this.persistenceUnitInfo.setExcludeUnlistedClasses("true".equals(content) || "1".equals(content) || content.isEmpty());
                    break;
                }
                case "shared-cache-mode": {
                    try {
                        this.persistenceUnitInfo.setSharedCacheMode(content);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SAXParseException("Unsupported value '%s' in {%s}%s".formatted(content, namespaceURI, localName), null, iae);
                    }
                }
                case "validation-mode": {
                    try {
                        this.persistenceUnitInfo.setValidationMode(content);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SAXParseException("Unsupported value '%s' in {%s}%s".formatted(content, namespaceURI, localName), null, iae);
                    }
                }
                case "persistence-unit": {
                    if (this.persistenceUnitInfo == null) break;
                    this.persistenceUnits.add(this.persistenceUnitInfo);
                    this.persistenceUnitInfo = null;
                    break;
                }
                case "qualifier": {
                    List<String> qualifiers = Arrays.stream(content.split(",")).map(String::trim).toList();
                    this.persistenceUnitInfo.setQualifierAnnotationNames(qualifiers);
                    break;
                }
                case "scope": {
                    this.persistenceUnitInfo.setScopeAnnotationName(content);
                    break;
                }
                case "persistence": 
                case "description": 
                case "properties": 
                case "property": {
                    break;
                }
                default: {
                    throw new SAXParseException("Unhandled element: {" + namespaceURI + "}" + localName, null);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.readCharacters) {
            this.stringBuilder.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

