/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Qualifier;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProviderRuntimeSpecifics;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

class CdiComponentProviderServerRuntimeSpecifics
implements CdiComponentProviderRuntimeSpecifics {
    private static final Set<Class<? extends Annotation>> JAX_RS_INJECT_ANNOTATIONS = new HashSet<Class<? extends Annotation>>(){
        {
            this.addAll(JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS);
            this.add(Context.class);
        }
    };
    private final Cache<Class<?>, Boolean> jaxRsResourceCache = new Cache(clazz -> Resource.from((Class)clazz, (boolean)true) != null && Resource.from((Class)clazz) != null);

    CdiComponentProviderServerRuntimeSpecifics() {
    }

    @Override
    public AnnotatedParameter<?> getAnnotatedParameter(final AnnotatedParameter<?> ap) {
        return new AnnotatedParameter(){

            public int getPosition() {
                return ap.getPosition();
            }

            public AnnotatedCallable getDeclaringCallable() {
                return ap.getDeclaringCallable();
            }

            public Type getBaseType() {
                return ap.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return ap.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                if (annotationType == JaxRsParamProducer.JaxRsParamQualifier.class) {
                    return (T)(CdiComponentProvider.hasAnnotation((Annotated)ap, JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS) ? JaxRsParamProducer.JaxRsParamQUALIFIER : null);
                }
                return (T)ap.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                HashSet<Annotation> result = new HashSet<Annotation>();
                for (Annotation a : ap.getAnnotations()) {
                    result.add(a);
                    Class<? extends Annotation> annotationType = a.annotationType();
                    if (!JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS.contains(annotationType)) continue;
                    result.add(JaxRsParamProducer.JaxRsParamQUALIFIER);
                }
                return result;
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return annotationType == JaxRsParamProducer.JaxRsParamQualifier.class && CdiComponentProvider.hasAnnotation((Annotated)ap, JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS) || ap.isAnnotationPresent(annotationType);
            }
        };
    }

    @Override
    public Set<Class<? extends Annotation>> getJaxRsInjectAnnotations() {
        return JAX_RS_INJECT_ANNOTATIONS;
    }

    @Override
    public boolean isAcceptableResource(Class<?> resource) {
        return Resource.isAcceptable(resource);
    }

    @Override
    public boolean isJaxRsResource(Class<?> resource) {
        return (Boolean)this.jaxRsResourceCache.apply(resource);
    }

    @Override
    public void clearJaxRsResource(ClassLoader loader) {
        Enumeration keys = this.jaxRsResourceCache.keys();
        while (keys.hasMoreElements()) {
            Class key = (Class)keys.nextElement();
            if (key.getClassLoader() != loader) continue;
            this.jaxRsResourceCache.remove((Object)key);
        }
    }

    @Override
    public boolean containsJaxRsParameterizedCtor(AnnotatedType annotatedType) {
        return CdiComponentProvider.containAnnotatedParameters(annotatedType.getConstructors(), JaxRsParamProducer.JAX_RS_STRING_PARAM_ANNOTATIONS);
    }

    @ApplicationScoped
    public static class JaxRsParamProducer {
        private static final JaxRsParamQualifier JaxRsParamQUALIFIER = new JaxRsParamQualifier(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JaxRsParamQualifier.class;
            }
        };
        static final Set<Class<? extends Annotation>> JAX_RS_STRING_PARAM_ANNOTATIONS = new HashSet<Class<? extends Annotation>>(){
            {
                this.add(PathParam.class);
                this.add(QueryParam.class);
                this.add(CookieParam.class);
                this.add(HeaderParam.class);
                this.add(MatrixParam.class);
                this.add(FormParam.class);
            }
        };
        final Cache<InjectionPoint, Parameter> parameterCache = new Cache(injectionPoint -> {
            AnnotatedParameter annotatedParameter;
            AnnotatedCallable callable;
            Annotated annotated = injectionPoint.getAnnotated();
            Class<?> clazz = injectionPoint.getMember().getDeclaringClass();
            if (annotated instanceof AnnotatedParameter && (callable = (annotatedParameter = (AnnotatedParameter)annotated).getDeclaringCallable()) instanceof AnnotatedConstructor) {
                AnnotatedConstructor ac = (AnnotatedConstructor)callable;
                int position = annotatedParameter.getPosition();
                List parameters = Parameter.create(clazz, clazz, (Constructor)ac.getJavaMember(), (boolean)false);
                return (Parameter)parameters.get(position);
            }
            return null;
        });

        @Produces
        @JaxRsParamQualifier
        public String getParameterValue(InjectionPoint injectionPoint, BeanManager beanManager) {
            Parameter parameter = (Parameter)this.parameterCache.apply((Object)injectionPoint);
            if (parameter != null) {
                InjectionManager injectionManager = ((CdiComponentProvider)beanManager.getExtension(CdiComponentProvider.class)).getEffectiveInjectionManager();
                Set providers = Providers.getProviders((InjectionManager)injectionManager, ValueParamProvider.class);
                ContainerRequest containerRequest = (ContainerRequest)injectionManager.getInstance(ContainerRequest.class);
                for (ValueParamProvider vfp : providers) {
                    Function paramValueSupplier = vfp.getValueProvider(parameter);
                    if (paramValueSupplier == null) continue;
                    return (String)paramValueSupplier.apply(containerRequest);
                }
            }
            return null;
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
        public static @interface JaxRsParamQualifier {
        }
    }
}

