/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.negativeinteger.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_ValidateCTTests test = new enumeration1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final BigInteger[] validValues = {new BigInteger("-59"), new BigInteger("-1100366"), new BigInteger("-27354619498689081"),
                                      new BigInteger("-528658858"), new BigInteger("-4155613"), new BigInteger("-998174005610134473"),
                                      new BigInteger("-709647298338194731"), new BigInteger("-5195709623"), new BigInteger("-246111632071438"),
                                      new BigInteger("-16605891804330308"), new BigInteger("-716908467"), new BigInteger("-7631138542947550895"),
                                      new BigInteger("-3027941073677"), new BigInteger("-4233598"), new BigInteger("-7729606"),
                                      new BigInteger("-53236688"), new BigInteger("-67291024"), new BigInteger("-716648")};
    final BigInteger[] invalidValues = {new BigInteger("0"), new BigInteger("-1"), new BigInteger("-60"), 
                                        new BigInteger("-10000"), new BigInteger("1100366"), new BigInteger("-716908468")};
    
    JAXBElement<BigInteger> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerEnumeration1(new BigInteger("-59"));
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerEnumeration1(new BigInteger("-59"));
        
        return testInvalid();
    }


}

