/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_ValidateCTTests test = new enumeration1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final int[] validValues = {9129683, -20676679, 981445, -427396, 96552477,
                               -671392302, 50712232, -941186, 13, -83484226};
    final int[] invalidValues = {2147483647, -2147483648, 0, -222, 222, 14};
    
    JAXBElement<Integer> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntEnumeration1(13);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntEnumeration1(13);
        
        return testInvalid();
    }


}

