/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardListSelectionPage;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplateWizardHelper;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class TemplateListSelectionPage
extends WizardListSelectionPage {
    private final ContentPage fContentPage;
    private Button fUseTemplate;
    private String fInitialTemplateId;

    public TemplateListSelectionPage(ElementList wizardElements, ContentPage page, String message) {
        super(wizardElements, message);
        this.fContentPage = page;
        this.setTitle(PDEUIMessages.WizardListSelectionPage_title);
        this.setDescription(PDEUIMessages.WizardListSelectionPage_desc);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_project_code_gen_page");
    }

    @Override
    public void createAbove(Composite container, int span) {
        this.fUseTemplate = new Button(container, 32);
        this.fUseTemplate.setText(PDEUIMessages.WizardListSelectionPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.fUseTemplate.setLayoutData((Object)gd);
        this.fUseTemplate.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.wizardSelectionViewer.getControl().setEnabled(this.fUseTemplate.getSelection());
            if (!this.fUseTemplate.getSelection()) {
                this.setDescription("");
            } else {
                this.setDescription(PDEUIMessages.WizardListSelectionPage_desc);
            }
            this.setDescriptionEnabled(this.fUseTemplate.getSelection());
            this.getContainer().updateButtons();
        }));
        this.fUseTemplate.setSelection(false);
    }

    @Override
    protected void initializeViewer() {
        this.wizardSelectionViewer.addFilter((ViewerFilter)new WizardFilter());
        if (this.getInitialTemplateId() != null) {
            this.selectInitialTemplate();
        }
        this.setDescriptionEnabled(false);
    }

    private void selectInitialTemplate() {
        Object[] children;
        Object[] objectArray = children = this.wizardElements.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            WizardElement welement = (WizardElement)child;
            if (welement.getID().equals(this.getInitialTemplateId())) {
                this.wizardSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)welement), true);
                this.setSelectedNode(this.createWizardNode(welement));
                this.setDescriptionText(welement.getDescription());
                break;
            }
            ++n2;
        }
    }

    @Override
    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            @Override
            public IBasePluginWizard createWizard() throws CoreException {
                IPluginContentWizard wizard = (IPluginContentWizard)this.wizardElement.createExecutableExtension();
                wizard.init(TemplateListSelectionPage.this.fContentPage.getData());
                return wizard;
            }
        };
    }

    @Override
    public IPluginContentWizard getSelectedWizard() {
        if (this.fUseTemplate.getSelection()) {
            return super.getSelectedWizard();
        }
        return null;
    }

    public boolean isPageComplete() {
        PluginFieldData data = (PluginFieldData)this.fContentPage.getData();
        boolean rcp = data.isRCPApplicationPlugin();
        return !rcp || this.fUseTemplate.getSelection() && rcp && this.getSelectedNode() != null;
    }

    @Override
    public boolean canFlipToNextPage() {
        IStructuredSelection ssel = this.wizardSelectionViewer.getStructuredSelection();
        return this.fUseTemplate.getSelection() && ssel != null && !ssel.isEmpty();
    }

    public String getInitialTemplateId() {
        return this.fInitialTemplateId;
    }

    public void setInitialTemplateId(String initialTemplateId) {
        this.fInitialTemplateId = initialTemplateId;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fContentPage.updateData();
            if (((PluginFieldData)this.fContentPage.getData()).isRCPApplicationPlugin()) {
                this.fUseTemplate.setSelection(true);
                this.fUseTemplate.setEnabled(false);
                this.wizardSelectionViewer.getControl().setEnabled(true);
            } else {
                if (!this.fUseTemplate.getSelection()) {
                    this.wizardSelectionViewer.getControl().setEnabled(false);
                }
                this.fUseTemplate.setEnabled(true);
            }
            this.wizardSelectionViewer.refresh();
        }
        super.setVisible(visible);
    }

    public boolean isAnyTemplateAvailable() {
        if (this.wizardSelectionViewer != null) {
            this.wizardSelectionViewer.refresh();
            Object firstElement = this.wizardSelectionViewer.getElementAt(0);
            if (firstElement != null) {
                return true;
            }
        }
        return false;
    }

    class WizardFilter
    extends ViewerFilter {
        WizardFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            PluginFieldData data = (PluginFieldData)TemplateListSelectionPage.this.fContentPage.getData();
            boolean simple = data.isSimple();
            boolean generate = data.doGenerateClass();
            boolean ui = data.isUIPlugin();
            boolean rcp = data.isRCPApplicationPlugin();
            boolean osgi = data.getOSGiFramework() != null;
            boolean automatic = osgi && data.isAutomaticMetadataGeneration();
            WizardElement welement = (WizardElement)element;
            boolean active = TemplateWizardHelper.isActive(welement);
            boolean uiFlag = TemplateWizardHelper.getFlag(welement, "ui-content", true);
            boolean javaFlag = TemplateWizardHelper.getFlag(welement, "java", true);
            boolean rcpFlag = TemplateWizardHelper.getFlag(welement, "rcp", false);
            boolean osgiFlag = TemplateWizardHelper.getFlag(welement, "pureOSGi", false);
            boolean bndFlag = osgiFlag && javaFlag && TemplateWizardHelper.getFlag(welement, "bnd", false);
            boolean activatorFlag = TemplateWizardHelper.getFlag(welement, "requiresActivator", false);
            if (!active) {
                return false;
            }
            if (osgi && simple) {
                return false;
            }
            if (simple) {
                return !javaFlag;
            }
            if (uiFlag && !ui) {
                return false;
            }
            if (activatorFlag && !generate) {
                return false;
            }
            if (!osgi && rcp != rcpFlag) {
                return false;
            }
            if (automatic && !bndFlag) {
                return false;
            }
            return osgi == osgiFlag && (!osgiFlag && !rcpFlag || ui == uiFlag);
        }
    }
}

