/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.event;

import fr.inria.zvtm.engine.ScrollLayer;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.event.ViewAdapter;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.event.MouseEvent;

public class ScrollingListener
extends ViewAdapter {
    static final short NOT_DRAGGING_ANY_SLIDER = 0;
    static final short DRAGGING_HSLIDER = 1;
    static final short DRAGGING_VSLIDER = 2;
    short dragMode = 0;
    ScrollLayer sl;
    Glyph g;
    int lastJPX;
    int lastJPY;
    int sli = 1;
    int cli = 0;

    public ScrollingListener(ScrollLayer sl, int scrollLayerIndex, int controlledLayerIndex) {
        this.sl = sl;
        this.sli = scrollLayerIndex;
        this.cli = controlledLayerIndex;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.lastJPX = jpx;
        this.lastJPY = jpy;
        this.g = v.lastGlyphEntered();
        if (this.g != null) {
            this.dragMode = this.g == this.sl.getVerticalSlider() ? (short)2 : (this.g == this.sl.getHorizontalSlider() ? (short)1 : 0);
        }
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.dragMode = 0;
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.g != null) {
            if (this.g == this.sl.getUpButton()) {
                this.sl.moveUp();
            } else if (this.g == this.sl.getDownButton()) {
                this.sl.moveDown();
            } else if (this.g == this.sl.getLeftButton()) {
                this.sl.moveLeft();
            } else if (this.g == this.sl.getRightButton()) {
                this.sl.moveRight();
            }
        }
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        if (!this.sl.cursorInside(jpx, jpy) && v.parent.getActiveLayer() == this.sli) {
            v.parent.setActiveLayer(this.cli);
        }
        this.lastJPX = jpx;
        this.lastJPY = jpy;
    }

    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        switch (this.dragMode) {
            case 2: {
                this.sl.draggingVerticalSlider(this.lastJPY - jpy);
                break;
            }
            case 1: {
                this.sl.draggingHorizontalSlider(jpx - this.lastJPX);
            }
        }
        this.lastJPX = jpx;
        this.lastJPY = jpy;
    }

    public void enterGlyph(Glyph g) {
    }

    public void exitGlyph(Glyph g) {
    }
}

