/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.projection.BProjectedCoordsP;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VShape<T>
extends ClosedShape {
    BProjectedCoordsP[] pc;
    float[] vertices;
    int[] xcoords;
    int[] ycoords;
    int[] lxcoords;
    int[] lycoords;

    public VShape(float[] v) {
        this(0.0, 0.0, 0, 10.0, v, Color.WHITE, Color.BLACK, 0.0, 1.0f);
    }

    public VShape(double x, double y, int z, double s, float[] v, Color c, double or) {
        this(x, y, z, s, v, c, Color.BLACK, or, 1.0f);
    }

    public VShape(double x, double y, int z, double s, float[] v, Color c, Color bc, double or) {
        this(x, y, z, s, v, c, bc, or, 1.0f);
    }

    public VShape(double x, double y, int z, double s, float[] v, Color c, Color bc, double or, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = s;
        this.vertices = v;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.lxcoords = new int[this.vertices.length];
        this.lycoords = new int[this.vertices.length];
        this.orient = or;
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new BProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new BProjectedCoordsP();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoordsP[] ta = this.pc;
                this.pc = new BProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new BProjectedCoordsP();
            } else {
                System.err.println("VShape:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new BProjectedCoordsP[1];
            this.pc[0] = new BProjectedCoordsP();
        } else {
            System.err.println("VShape:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return this.alphaC == null && this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public String getVerticesAsText() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            res.append(this.vertices[i] + ",");
        }
        res.append(this.vertices[this.vertices.length - 1]);
        return res.toString();
    }

    @Override
    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cr = (int)Math.round(this.size / 2.0 * this.coef);
        double vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            this.xcoords[j] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            this.ycoords[j] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle += Math.PI * 2 / (double)this.vertices.length;
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, this.vertices.length);
        } else {
            this.pc[i].p.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcr = (int)Math.round(this.size / 2.0 * this.coef);
        double vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            this.lxcoords[j] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            this.lycoords[j] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle += Math.PI * 2 / (double)this.vertices.length;
        }
        this.lxcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.lycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.lxcoords, this.lycoords, this.vertices.length);
        } else {
            this.pc[i].lp.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.lxcoords[j];
                this.pc[i].lp.ypoints[j] = this.lycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cr > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcr > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        }
    }

    public double getArea() {
        double[] xcoordsForArea = new double[this.vertices.length];
        double[] ycoordsForArea = new double[this.vertices.length];
        double vertexAngle = this.orient;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            xcoordsForArea[i] = this.vx + this.size / 2.0 * Math.cos(vertexAngle) * (double)this.vertices[i];
            ycoordsForArea[i] = this.vy + this.size / 2.0 * Math.sin(vertexAngle) * (double)this.vertices[i];
            vertexAngle += Math.PI * 2 / (double)this.vertices.length;
        }
        xcoordsForArea[this.vertices.length - 1] = this.vx + this.size / 2.0 * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1];
        ycoordsForArea[this.vertices.length - 1] = this.vy + this.size / 2.0 * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1];
        double res = 0.0;
        for (int j = 0; j < this.vertices.length; ++j) {
            int k = (j + 1) % this.vertices.length;
            res += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        return (res /= 2.0) < 0.0 ? -res : res;
    }

    public Point2D.Double getCentroid() {
        int k;
        int j;
        double[] xcoordsForArea = new double[this.vertices.length];
        double[] ycoordsForArea = new double[this.vertices.length];
        double vertexAngle = this.orient;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            xcoordsForArea[i] = this.vx + this.size / 2.0 * Math.cos(vertexAngle) * (double)this.vertices[i];
            ycoordsForArea[i] = this.vy + this.size / 2.0 * Math.sin(vertexAngle) * (double)this.vertices[i];
            vertexAngle += Math.PI * 2 / (double)this.vertices.length;
        }
        xcoordsForArea[this.vertices.length - 1] = this.vx + this.size / 2.0 * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1];
        ycoordsForArea[this.vertices.length - 1] = this.vy + this.size / 2.0 * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1];
        double area = 0.0;
        for (j = 0; j < this.vertices.length; ++j) {
            k = (j + 1) % this.vertices.length;
            area += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        area /= 2.0;
        double factor = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (j = 0; j < this.vertices.length; ++j) {
            k = (j + 1) % this.vertices.length;
            factor = xcoordsForArea[j] * ycoordsForArea[k] - xcoordsForArea[k] * ycoordsForArea[j];
            cx += (xcoordsForArea[j] + xcoordsForArea[k]) * factor;
            cy += (ycoordsForArea[j] + ycoordsForArea[k]) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        Point2D.Double res = new Point2D.Double(cx *= factor, cy *= factor);
        return res;
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }

    @Override
    public Object clone() {
        VShape<T> res = new VShape<T>(this.vx, this.vy, this.vz, this.size, (float[])this.vertices.clone(), this.color, this.borderColor, this.orient);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

