/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.GraphicsManager;

public class RadarEvtHdlr
implements ViewListener {
    GraphicsManager grMngr;
    private boolean draggingRegionRect = false;

    RadarEvtHdlr(GraphicsManager gm) {
        this.grMngr = gm;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        v.getVCursor().stickGlyph(this.grMngr.observedRegion);
        v.getVCursor().setSensitivity(false);
        this.draggingRegionRect = true;
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            v.getVCursor().setSensitivity(true);
            v.getVCursor().unstickLastGlyph();
            this.draggingRegionRect = false;
        }
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        Point2D.Double lp = v.getVCursor().getLocation();
        Camera c = this.grMngr.mSpace.getCamera(0);
        Animation a = this.grMngr.vsm.getAnimationManager().getAnimationFactory().createCameraTranslation(300, c, new Point2D.Double(lp.x - c.vx, lp.y - c.vy), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.grMngr.vsm.getAnimationManager().startAnimation(a, false);
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.grMngr.rView.getGlobalView(this.grMngr.mSpace.getCamera(1), 500);
        this.grMngr.cameraMoved(null, null, 0.0);
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        v.getVCursor().stickGlyph(this.grMngr.observedRegion);
        v.getVCursor().setSensitivity(false);
        this.draggingRegionRect = true;
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            v.getVCursor().setSensitivity(true);
            v.getVCursor().unstickLastGlyph();
            this.draggingRegionRect = false;
        }
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
    }

    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            this.grMngr.updateMainViewFromRadar();
        }
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
        Camera c = this.grMngr.mSpace.getCamera(0);
        double a = (c.focal + Math.abs(c.altitude)) / c.focal;
        if (wheelDirection == 1) {
            c.altitudeOffset(a * 10.0);
            this.grMngr.cameraMoved(null, null, 0.0);
        } else {
            c.altitudeOffset(-a * 10.0);
            this.grMngr.cameraMoved(null, null, 0.0);
        }
    }

    public void enterGlyph(Glyph g) {
    }

    public void exitGlyph(Glyph g) {
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (code == 33) {
            this.grMngr.getHigherView();
        } else if (code == 34) {
            this.grMngr.getLowerView();
        } else if (code == 36) {
            this.grMngr.getGlobalView();
        } else if (code == 38) {
            this.grMngr.translateView((short)0);
        } else if (code == 40) {
            this.grMngr.translateView((short)1);
        } else if (code == 37) {
            this.grMngr.translateView((short)2);
        } else if (code == 39) {
            this.grMngr.translateView((short)3);
        }
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
        this.grMngr.rView.destroyView();
        this.grMngr.rView = null;
    }
}

