/*
 * Decompiled with CFR 0.152.
 */
package plugin2analyse;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SWTQualitativeInfo
extends Canvas {
    public static int DISK = 0;
    public static int HISTOGRAMME = 1;
    public static int BAR = 2;
    public static int SPIDER = 3;

    public SWTQualitativeInfo(Composite parent, int style, final int[] pourcent, final String[] labels, final Color[] colors, final int type) {
        super(parent, style);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(e.gc.getDevice().getSystemColor(1));
                e.gc.fillRectangle(0, 0, 600, 300);
                if (type == BAR) {
                    e.gc.setBackground(e.gc.getDevice().getSystemColor(2));
                    e.gc.fillRectangle(29, 29, 102, 202);
                    int x = 30;
                    int y = 30;
                    int i = 0;
                    while (i < pourcent.length) {
                        e.gc.setBackground(colors[i]);
                        e.gc.fillRectangle(x, y, 100, pourcent[i] * 2);
                        e.gc.setBackground(e.gc.getDevice().getSystemColor(1));
                        e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
                        e.gc.drawString(String.valueOf(labels[i]) + " " + pourcent[i] + "%", x + 110, y + 10);
                        y += pourcent[i] * 2;
                        ++i;
                    }
                } else if (type == DISK) {
                    e.gc.setBackground(e.gc.getDevice().getSystemColor(2));
                    int startAngle = 0;
                    int arcAngle = 0;
                    int x = 30;
                    int y = 240;
                    int i = 0;
                    while (i < pourcent.length) {
                        e.gc.setBackground(colors[i]);
                        arcAngle = (int)((double)pourcent[i] * 3.6);
                        e.gc.fillArc(30, 30, 200, 200, startAngle, arcAngle);
                        e.gc.fillRectangle(x, y, 10, 10);
                        e.gc.setBackground(e.gc.getDevice().getSystemColor(1));
                        e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
                        e.gc.drawString(String.valueOf(labels[i]) + " " + pourcent[i] + "%", x + 20, y - 2);
                        y += 20;
                        startAngle += arcAngle;
                        ++i;
                    }
                } else if (type == SPIDER) {
                    Display device = Display.getCurrent();
                    int xDecalage = 100;
                    int yDecalage = 100;
                    int rayon = 150;
                    int xCentre = xDecalage + rayon;
                    int yCentre = yDecalage + rayon;
                    int rayonCentre = 2;
                    e.gc.setBackground(device.getSystemColor(2));
                    e.gc.fillOval(xCentre - rayonCentre, yCentre - rayonCentre, 2 * rayonCentre, 2 * rayonCentre);
                    e.gc.setBackground(device.getSystemColor(37));
                    e.gc.drawLine(xCentre, yCentre, xCentre, yCentre - rayon);
                    e.gc.drawString("coverage", xCentre - 30, yCentre - rayon - 30);
                    int xVariation1 = (int)((double)rayon * 0.951);
                    int yVariation1 = (int)((double)rayon * 0.309);
                    e.gc.drawLine(xCentre, yCentre, xCentre - xVariation1, yCentre - yVariation1);
                    e.gc.drawString("width", xCentre - xVariation1 - 40, yCentre - yVariation1 - 10);
                    e.gc.drawLine(xCentre, yCentre, xCentre + xVariation1, yCentre - yVariation1);
                    e.gc.drawString("context", xCentre + xVariation1 + 10, yCentre - yVariation1 - 10);
                    int xVariation2 = (int)((double)rayon * 0.588);
                    int yVariation2 = (int)((double)rayon * 0.809);
                    e.gc.drawLine(xCentre, yCentre, xCentre - xVariation2, yCentre + yVariation2);
                    e.gc.drawString("depth", xCentre - xVariation2 - 20, yCentre + yVariation2 + 10);
                    e.gc.drawLine(xCentre, yCentre, xCentre + xVariation2, yCentre + yVariation2);
                    e.gc.drawString("step", xCentre + xVariation2 - 20, yCentre + yVariation2 + 10);
                    e.gc.setBackground(device.getSystemColor(5));
                    SWTQualitativeInfo.this.draw5Segments(e, rayon / 4, xCentre, yCentre);
                    SWTQualitativeInfo.this.draw5Segments(e, rayon / 2, xCentre, yCentre);
                    SWTQualitativeInfo.this.draw5Segments(e, rayon / 4 * 3, xCentre, yCentre);
                    SWTQualitativeInfo.this.draw5Segments(e, rayon, xCentre, yCentre);
                    SWTQualitativeInfo.this.draw5SegmentsBis(e, xCentre, yCentre, rayon, 50, 25, 90, 30, 20, 20, 56, 12, 24, 16);
                } else {
                    e.gc.setBackground(e.gc.getDevice().getSystemColor(35));
                    e.gc.fillRectangle(35, 29, labels.length * 30, 200);
                    e.gc.setBackground(e.gc.getDevice().getSystemColor(2));
                    e.gc.fillRectangle(29, 29, 5, 2);
                    e.gc.fillRectangle(29, 77, 5, 2);
                    e.gc.fillRectangle(29, 127, 5, 2);
                    e.gc.fillRectangle(29, 177, 5, 2);
                    e.gc.fillRectangle(29, 227, 5, 2);
                    e.gc.setBackground(e.gc.getDevice().getSystemColor(1));
                    e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
                    e.gc.drawString("100%", 2, 19);
                    e.gc.drawString("75%", 2, 67);
                    e.gc.drawString("50%", 2, 117);
                    e.gc.drawString("25%", 2, 167);
                    e.gc.drawString("0%", 2, 217);
                    int x = 39;
                    int y = 30;
                    int i = 0;
                    while (i < pourcent.length) {
                        e.gc.setBackground(colors[i]);
                        e.gc.fillRectangle(x, (100 - pourcent[i]) * 2 + 29, 20, pourcent[i] * 2);
                        e.gc.fillRectangle(labels.length * 30 + 40, y + 10, 10, 10);
                        e.gc.setBackground(e.gc.getDevice().getSystemColor(1));
                        e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
                        e.gc.drawString(String.valueOf(labels[i]) + " " + pourcent[i] + "%", labels.length * 30 + 50, y + 10);
                        y += 20;
                        x += 30;
                        ++i;
                    }
                }
            }
        });
    }

    public void draw5Segments(PaintEvent pe, int lg, int xCentre, int yCentre) {
        int xVariation1 = (int)((double)lg * 0.951);
        int yVariation1 = (int)((double)lg * 0.309);
        pe.gc.drawLine(xCentre, yCentre - lg, xCentre - xVariation1, yCentre - yVariation1);
        pe.gc.drawLine(xCentre, yCentre - lg, xCentre + xVariation1, yCentre - yVariation1);
        int xVariation2 = (int)((double)lg * 0.588);
        int yVariation2 = (int)((double)lg * 0.809);
        pe.gc.drawLine(xCentre - xVariation1, yCentre - yVariation1, xCentre - xVariation2, yCentre + yVariation2);
        pe.gc.drawLine(xCentre + xVariation1, yCentre - yVariation1, xCentre + xVariation2, yCentre + yVariation2);
        pe.gc.drawLine(xCentre - xVariation2, yCentre + yVariation2, xCentre + xVariation2, yCentre + yVariation2);
    }

    public void draw5SegmentsBis(PaintEvent pe, int xCentre, int yCentre, int rayon, int maxCoverage, int currentCoverage, int maxWidth, int currentWidth, int maxDepth, int currentDepth, int maxStep, int currentStep, int maxContext, int currentContext) {
        int lgPoint = rayon * currentCoverage / maxCoverage;
        int xP1 = xCentre;
        int yP1 = yCentre - lgPoint;
        lgPoint = rayon * currentWidth / maxWidth;
        int xVariation = (int)((double)lgPoint * 0.951);
        int yVariation = (int)((double)lgPoint * 0.309);
        int xP2 = xCentre - xVariation;
        int yP2 = yCentre - yVariation;
        lgPoint = rayon * currentDepth / maxDepth;
        xVariation = (int)((double)lgPoint * 0.588);
        yVariation = (int)((double)lgPoint * 0.809);
        int xP3 = xCentre - xVariation;
        int yP3 = yCentre + yVariation;
        lgPoint = rayon * currentStep / maxStep;
        xVariation = (int)((double)lgPoint * 0.588);
        yVariation = (int)((double)lgPoint * 0.809);
        int xP4 = xCentre + xVariation;
        int yP4 = yCentre + yVariation;
        lgPoint = rayon * currentContext / maxContext;
        xVariation = (int)((double)lgPoint * 0.951);
        yVariation = (int)((double)lgPoint * 0.309);
        int xP5 = xCentre + xVariation;
        int yP5 = yCentre - yVariation;
        Display device = Display.getCurrent();
        pe.gc.setBackground(device.getSystemColor(3));
        pe.gc.setForeground(device.getSystemColor(3));
        pe.gc.setLineWidth(3);
        pe.gc.drawLine(xP1, yP1, xP2, yP2);
        pe.gc.drawLine(xP2, yP2, xP3, yP3);
        pe.gc.drawLine(xP3, yP3, xP4, yP4);
        pe.gc.drawLine(xP4, yP4, xP5, yP5);
        pe.gc.drawLine(xP5, yP5, xP1, yP1);
    }

    public static SWTQualitativeInfo createSpider(Composite parent) {
        int[] pourcent = new int[]{30, 20, 10, 40};
        String[] labels = new String[]{"Added", "Modified", "Deleted", "Stable"};
        Display device = Display.getCurrent();
        Color[] colors = new Color[]{device.getSystemColor(5), device.getSystemColor(13), device.getSystemColor(3), device.getSystemColor(7)};
        SWTQualitativeInfo canva = new SWTQualitativeInfo(parent, 0, pourcent, labels, colors, SPIDER);
        return canva;
    }

    public static void main(String[] a) {
        Display display = new Display();
        Shell shell = new Shell(display);
        int[] pourcent = new int[]{30, 20, 10, 40};
        String[] labels = new String[]{"Added", "Modified", "Deleted", "Stable"};
        Display device = Display.getCurrent();
        Color[] colors = new Color[]{device.getSystemColor(5), device.getSystemColor(13), device.getSystemColor(3), device.getSystemColor(7)};
        new SWTQualitativeInfo((Composite)shell, 0, pourcent, labels, colors, SPIDER);
        shell.setLayout((Layout)new FillLayout());
        shell.pack();
        shell.setSize(500, 500);
        shell.setText("Repartition");
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

