/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public abstract class FilteredTableBaseHandler
extends AbstractHandler
implements IExecutableExtension {
    private static final String EMPTY_STRING = "";
    private boolean bypassFocusLost;
    private Object selection;
    protected IWorkbenchWindow window;
    protected WorkbenchPage page;
    protected boolean gotoDirection;
    private TriggerSequence[] backwardTriggerSequences = null;
    protected ParameterizedCommand commandBackward = null;
    protected ParameterizedCommand commandForward = null;
    private TriggerSequence[] forwardTriggerSequences = null;
    protected Object result;
    protected Shell dialog;
    private Text text;
    private Label labelTitle = null;
    private Label labelSeparator;
    private Table table;
    private TableViewer tableViewer;
    private TableColumn tc;
    private TableViewerColumn tableViewerColumn;
    private FocusAdapter fAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            FilteredTableBaseHandler.this.dialog.getDisplay().asyncExec(() -> {
                if (FilteredTableBaseHandler.this.dialog.isDisposed()) {
                    return;
                }
                Control fc = FilteredTableBaseHandler.this.dialog.getDisplay().getFocusControl();
                if (fc != FilteredTableBaseHandler.this.text && fc != FilteredTableBaseHandler.this.table && fc != FilteredTableBaseHandler.this.dialog && !FilteredTableBaseHandler.this.bypassFocusLost) {
                    FilteredTableBaseHandler.this.cancel(FilteredTableBaseHandler.this.dialog);
                }
            });
        }
    };
    private static String RE_TEXT = "[ \\w\\d_\\-\\+\\.\\*\\?\\$\\|\\(\\)\\[\\]\\{\\}@#]";
    private PerspectiveLabelProvider perspectiveLabelProvider = null;

    protected int getCurrentItemIndex() {
        return 0;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        this.page = (WorkbenchPage)this.window.getActivePage();
        IWorkbenchPart activePart = this.page.getActivePart();
        this.getTriggers();
        this.openDialog(this.page, activePart);
        this.clearTriggers();
        this.activate(this.page, this.selection);
        return null;
    }

    public void openDialog(WorkbenchPage page, IWorkbenchPart activePart) {
        Shell shell = null;
        this.selection = null;
        if (activePart != null) {
            shell = activePart.getSite().getShell();
        }
        if (shell == null) {
            shell = this.window.getShell();
        }
        this.dialog = new Shell(shell, 0);
        this.dialog.setBackground(this.getBackground());
        this.dialog.setMinimumSize(new Point(120, 50));
        Display display = this.dialog.getDisplay();
        this.dialog.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setBackground(this.getBackground());
        GridLayout gl_composite = new GridLayout(1, false);
        composite.setLayout((Layout)gl_composite);
        if (this.isFiltered()) {
            this.text = new Text(composite, 0);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.text.setBackground(this.getBackground());
        } else {
            this.labelTitle = new Label(composite, 0);
            this.labelTitle.setText(this.getTableHeader(activePart));
            this.labelTitle.setBackground(this.getBackground());
            this.labelTitle.setForeground(this.getForeground());
        }
        this.labelSeparator = new Label(composite, 256);
        this.labelSeparator.setBackgroundImage(this.getSeparatorBgImage());
        GridData gd_label = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_label.heightHint = 1;
        this.labelSeparator.setLayoutData((Object)gd_label);
        this.tableViewer = new TableViewer(composite, 65540);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setBackground(this.getBackground());
        this.tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.setLabelProvider(this.tableViewerColumn);
        this.tc = this.tableViewerColumn.getColumn();
        this.tc.setResizable(false);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        if (this.isFiltered()) {
            this.tableViewer.addFilter(this.getFilter());
            this.addModifyListener(this.text);
            this.addKeyListener(this.text);
            this.text.setMessage(WorkbenchMessages.FilteredTableBase_Filter);
            this.text.setText(EMPTY_STRING);
        }
        this.tableViewer.setInput(this.getInput(page));
        int tableItemCount = this.table.getItemCount();
        switch (tableItemCount) {
            case 0: {
                this.cancel(this.dialog);
                return;
            }
            case 1: {
                this.table.setSelection(0);
                break;
            }
            default: {
                int i;
                int currentItemIndex = this.getCurrentItemIndex();
                if (this.gotoDirection) {
                    i = currentItemIndex + 1;
                    if (i >= tableItemCount) {
                        i = 0;
                    }
                } else {
                    i = currentItemIndex - 1;
                    if (i < 0) {
                        i = tableItemCount - 1;
                    }
                }
                this.table.setSelection(i);
            }
        }
        this.tc.pack();
        this.table.pack();
        this.dialog.pack();
        Rectangle tableBounds = this.table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, this.table.getItemHeight() * 15);
        this.table.setBounds(tableBounds);
        Rectangle dialogBounds = this.dialog.getBounds();
        dialogBounds.height = !this.isFiltered() ? this.labelTitle.getBounds().height + this.labelSeparator.getBounds().height + tableBounds.height + gl_composite.marginHeight * 2 + gl_composite.verticalSpacing * 2 : this.text.getBounds().height + this.labelSeparator.getBounds().height + tableBounds.height + gl_composite.marginHeight * 2 + gl_composite.verticalSpacing * 2;
        this.dialog.setBounds(dialogBounds);
        this.tc.setWidth(this.table.getClientArea().width);
        if (this.isFiltered()) {
            this.text.setFocus();
            this.text.addFocusListener((FocusListener)this.fAdapter);
        } else {
            this.table.setFocus();
        }
        this.table.addFocusListener((FocusListener)this.fAdapter);
        this.dialog.addFocusListener((FocusListener)this.fAdapter);
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                if (FilteredTableBaseHandler.this.table.equals(e.getSource())) {
                    TableItem o;
                    if (this.fLastItem == null ^ (o = FilteredTableBaseHandler.this.table.getItem(new Point(e.x, e.y))) == null) {
                        FilteredTableBaseHandler.this.table.setCursor(o == null ? null : FilteredTableBaseHandler.this.table.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TableItem) {
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            FilteredTableBaseHandler.this.table.setSelection(new TableItem[]{this.fLastItem});
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        this.setDialogLocation(this.dialog, activePart);
        IContextService contextService = (IContextService)this.window.getWorkbench().getService(IContextService.class);
        try {
            this.dialog.open();
            this.addMouseListener(this.table, this.dialog);
            contextService.registerShell(this.dialog, 1);
            this.addKeyListener(this.table, this.dialog);
            this.addTraverseListener(this.table);
            while (!this.dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!this.dialog.isDisposed()) {
                this.cancel(this.dialog);
            }
            contextService.unregisterShell(this.dialog);
        }
    }

    private Image getSeparatorBgImage() {
        Image backgroundImage = new Image((Device)Display.getDefault(), 1, 1);
        GC gc = new GC((Drawable)backgroundImage);
        gc.setBackground(new Color((Device)this.dialog.getDisplay(), 127, 127, 127));
        gc.fillRectangle(0, 0, 1, 1);
        gc.dispose();
        return backgroundImage;
    }

    protected void setDialogLocation(Shell dialog, IWorkbenchPart activePart) {
        Display display = dialog.getDisplay();
        Rectangle dialogBounds = dialog.getBounds();
        Rectangle parentBounds = dialog.getParent().getBounds();
        Rectangle monitorBounds = activePart == null ? display.getPrimaryMonitor().getBounds() : ((Control)((PartSite)activePart.getSite()).getModel().getWidget()).getMonitor().getBounds();
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        if (!monitorBounds.contains(dialogBounds.x, dialogBounds.y) || !monitorBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
            dialogBounds.x = Math.max(0, monitorBounds.x + (monitorBounds.width - dialogBounds.width) / 2);
            dialogBounds.y = Math.max(0, monitorBounds.y + (monitorBounds.height - dialogBounds.height) / 2);
        }
        dialog.setLocation(dialogBounds.x, dialogBounds.y);
    }

    protected void clearTriggers() {
        this.forwardTriggerSequences = null;
        this.backwardTriggerSequences = null;
    }

    protected void getTriggers() {
        this.commandForward = this.getForwardCommand();
        this.commandBackward = this.getBackwardCommand();
        IBindingService bindingService = (IBindingService)this.window.getWorkbench().getService(IBindingService.class);
        this.forwardTriggerSequences = bindingService.getActiveBindingsFor(this.commandForward);
        this.backwardTriggerSequences = bindingService.getActiveBindingsFor(this.commandBackward);
    }

    private KeyStroke computeKeyStroke(KeyEvent e) {
        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
        return SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
    }

    boolean computeAcceleratorForward(KeyEvent e) {
        boolean acceleratorForward = false;
        if (this.commandForward != null && this.forwardTriggerSequences != null) {
            int forwardCount = this.forwardTriggerSequences.length;
            int i = 0;
            while (i < forwardCount) {
                TriggerSequence triggerSequence = this.forwardTriggerSequences[i];
                Trigger[] triggers = triggerSequence.getTriggers();
                int triggersLength = triggers.length;
                if (triggersLength > 0 && triggers[triggersLength - 1].equals((Object)this.computeKeyStroke(e))) {
                    acceleratorForward = true;
                    break;
                }
                ++i;
            }
        }
        return acceleratorForward;
    }

    boolean computeAcceleratorBackward(KeyEvent e) {
        boolean acceleratorBackward = false;
        if (this.commandBackward != null && this.backwardTriggerSequences != null) {
            int backwardCount = this.backwardTriggerSequences.length;
            int i = 0;
            while (i < backwardCount) {
                TriggerSequence triggerSequence = this.backwardTriggerSequences[i];
                Trigger[] triggers = triggerSequence.getTriggers();
                int triggersLength = triggers.length;
                if (triggersLength > 0 && triggers[triggersLength - 1].equals((Object)this.computeKeyStroke(e))) {
                    acceleratorBackward = true;
                    break;
                }
                ++i;
            }
        }
        return acceleratorBackward;
    }

    protected void addModifyListener(Text text) {
        text.addModifyListener(e -> {
            String searchText = ((Text)e.widget).getText();
            this.setMatcherString(searchText);
            this.tableViewer.refresh();
            if (this.tableViewer.getTable().getColumnCount() > 0) {
                this.tableViewer.getTable().select(0);
            }
        });
    }

    protected void addKeyListener(final Text text) {
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (FilteredTableBaseHandler.this.computeAcceleratorForward(e)) {
                    FilteredTableBaseHandler.this.moveForward();
                } else if (FilteredTableBaseHandler.this.computeAcceleratorBackward(e)) {
                    FilteredTableBaseHandler.this.moveBackward();
                }
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        FilteredTableBaseHandler.this.ok(FilteredTableBaseHandler.this.dialog, FilteredTableBaseHandler.this.table);
                        break;
                    }
                    case 0x1000002: 
                    case 0x1000006: {
                        FilteredTableBaseHandler.this.moveForward();
                        break;
                    }
                    case 0x1000001: 
                    case 0x1000005: {
                        FilteredTableBaseHandler.this.moveBackward();
                        break;
                    }
                    case 27: {
                        FilteredTableBaseHandler.this.cancel(FilteredTableBaseHandler.this.dialog);
                        break;
                    }
                    case 127: {
                        if (text.getText().length() != 0) break;
                        FilteredTableBaseHandler.this.deleteSelectedItem();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected Color getForeground() {
        return this.dialog.getDisplay().getSystemColor(24);
    }

    protected Color getBackground() {
        return this.dialog.getDisplay().getSystemColor(25);
    }

    protected void addKeyListener(final Table table, final Shell dialog) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent e) {
                int keyCode = e.keyCode;
                char character = e.character;
                boolean acceleratorForward = FilteredTableBaseHandler.this.computeAcceleratorForward(e);
                boolean acceleratorBackward = FilteredTableBaseHandler.this.computeAcceleratorBackward(e);
                if (character == '\r' || character == '\n') {
                    FilteredTableBaseHandler.this.ok(dialog, table);
                } else if (acceleratorForward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    FilteredTableBaseHandler.this.moveForward();
                } else if (acceleratorBackward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    FilteredTableBaseHandler.this.moveBackward();
                } else if (keyCode == 127 && FilteredTableBaseHandler.this.isFiltered()) {
                    e.doit = false;
                    FilteredTableBaseHandler.this.deleteSelectedItem();
                } else if (keyCode != 65536 && keyCode != 0x400000 && keyCode != 262144 && keyCode != 131072 && keyCode != 0x1000002 && keyCode != 0x1000001 && keyCode != 0x1000006 && keyCode != 0x1000005 && keyCode != 0x1000003 && keyCode != 0x1000004) {
                    if (!FilteredTableBaseHandler.this.isFiltered()) {
                        FilteredTableBaseHandler.this.cancel(dialog);
                    } else {
                        String s = Character.toString(e.character);
                        if (e.keyCode == 8) {
                            String curText = FilteredTableBaseHandler.this.text.getText();
                            if (curText.length() > 0) {
                                FilteredTableBaseHandler.this.text.setText(curText.substring(0, curText.length() - 1));
                            }
                        } else if (s.matches(RE_TEXT)) {
                            FilteredTableBaseHandler.this.text.append(Character.toString(e.character));
                        } else {
                            FilteredTableBaseHandler.this.cancel(dialog);
                        }
                    }
                } else if ((keyCode == 0x1000002 || keyCode == 0x1000006) && table.getSelectionIndex() == table.getItemCount() - 1) {
                    FilteredTableBaseHandler.this.moveForward();
                    e.doit = false;
                } else if ((keyCode == 0x1000001 || keyCode == 0x1000005) && table.getSelectionIndex() == 0) {
                    FilteredTableBaseHandler.this.moveBackward();
                    e.doit = false;
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent e) {
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                boolean stickyCycle = store.getBoolean("STICKY_CYCLE");
                if (!FilteredTableBaseHandler.this.isFiltered() && !stickyCycle && (this.firstKey || this.quickReleaseMode) && keyCode == stateMask) {
                    FilteredTableBaseHandler.this.ok(dialog, table);
                }
            }
        });
    }

    private void moveForward() {
        int index = this.table.getSelectionIndex();
        if (this.isFiltered()) {
            if (this.text.isFocusControl()) {
                this.table.setFocus();
            } else if (index == this.table.getItemCount() - 1) {
                this.text.setFocus();
                return;
            }
        }
        this.table.setSelection((index + 1) % this.table.getItemCount());
    }

    private void moveBackward() {
        int index = this.table.getSelectionIndex();
        if (!this.isFiltered()) {
            this.table.setSelection(index >= 1 ? index - 1 : this.table.getItemCount() - 1);
        } else if (this.text.isFocusControl()) {
            this.table.setFocus();
            this.table.setSelection(index >= 1 ? index - 1 : this.table.getItemCount() - 1);
        } else if (index == 0) {
            this.text.setFocus();
        } else {
            this.table.setSelection(index >= 1 ? index - 1 : this.table.getItemCount() - 1);
        }
    }

    private void deleteSelectedItem() {
        int index = this.table.getSelectionIndex();
        if (index == -1 || index >= this.table.getItemCount()) {
            return;
        }
        TableItem item = this.table.getItem(index);
        this.close(item);
    }

    private void close(TableItem ti) {
        if (ti.getData() instanceof EditorReference) {
            int index = this.table.indexOf(ti);
            EditorReference ed = (EditorReference)ti.getData();
            this.bypassFocusLost = true;
            this.page.closeEditors(new IEditorReference[]{ed}, true);
            this.bypassFocusLost = false;
            this.table.setFocus();
            this.tableViewer.setInput(this.getInput(this.page));
            if (this.table.getItemCount() == 0) {
                this.cancel(this.dialog);
            }
            if (this.table.isDisposed()) {
                return;
            }
            if (index > 0 && index <= this.table.getItemCount()) {
                --index;
            }
            this.table.setSelection(index);
        }
    }

    protected final void addTraverseListener(Table table) {
        table.addTraverseListener(event -> {
            boolean bl = event.doit = false;
        });
    }

    protected void activate(IWorkbenchPage page, Object selectedItem) {
        if (selectedItem != null) {
            if (selectedItem instanceof MStackElement) {
                EPartService partService = (EPartService)page.getWorkbenchWindow().getService(EPartService.class);
                partService.showPart(((MStackElement)selectedItem).getElementId(), EPartService.PartState.ACTIVATE);
                return;
            }
            if (selectedItem instanceof IEditorReference) {
                page.setEditorAreaVisible(true);
            }
            if (selectedItem instanceof IWorkbenchPartReference) {
                IWorkbenchPart part = ((IWorkbenchPartReference)selectedItem).getPart(true);
                if (part != null) {
                    page.activate(part);
                }
                return;
            }
            if (selectedItem instanceof IPerspectiveDescriptor) {
                IPerspectiveDescriptor persp = (IPerspectiveDescriptor)selectedItem;
                page.setPerspective(persp);
                IWorkbenchPart activePart = page.getActivePart();
                if (activePart != null) {
                    activePart.setFocus();
                }
            }
        }
    }

    protected void cancel(Shell dialog) {
        this.selection = null;
        dialog.close();
    }

    protected void ok(Shell dialog, Table table) {
        TableItem[] items = table.getSelection();
        if (items != null && items.length == 1) {
            this.selection = items[0].getData();
        }
        dialog.close();
    }

    protected void addMouseListener(final Table table, final Shell dialog) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                FilteredTableBaseHandler.this.ok(dialog, table);
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 3) {
                    FilteredTableBaseHandler.this.ok(dialog, table);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    TableItem ti;
                    if (table.equals(e.getSource()) && (ti = table.getItem(new Point(e.x, e.y))) != null && ti.getData() instanceof EditorReference) {
                        Menu menu = new Menu((Control)table);
                        MenuItem mi = new MenuItem(menu, 0);
                        mi.setText(WorkbenchMessages.FilteredTableBaseHandler_Close);
                        mi.addListener(13, se -> FilteredTableBaseHandler.this.close(ti));
                        menu.setVisible(true);
                    }
                } else {
                    FilteredTableBaseHandler.this.ok(dialog, table);
                }
            }
        });
    }

    protected boolean isFiltered() {
        return false;
    }

    protected ViewerFilter getFilter() {
        return null;
    }

    protected void setMatcherString(String pattern) {
    }

    private PerspectiveLabelProvider getPerspectiveLabelProvider() {
        if (this.perspectiveLabelProvider == null) {
            this.perspectiveLabelProvider = new PerspectiveLabelProvider(false);
        }
        return this.perspectiveLabelProvider;
    }

    protected String getWorkbenchPartReferenceText(WorkbenchPartReference ref) {
        if (ref.isDirty()) {
            return "*" + ref.getTitle();
        }
        return ref.getTitle();
    }

    protected void setLabelProvider(TableViewerColumn tableViewerColumn) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.getColumnLabelProvider());
    }

    protected ColumnLabelProvider getColumnLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilteredTableItem) {
                    return ((FilteredTableItem)element).text;
                }
                if (element instanceof WorkbenchPartReference) {
                    return FilteredTableBaseHandler.this.getWorkbenchPartReferenceText((WorkbenchPartReference)element);
                }
                if (element instanceof IPerspectiveDescriptor) {
                    IPerspectiveDescriptor desc = (IPerspectiveDescriptor)element;
                    String text = FilteredTableBaseHandler.this.getPerspectiveLabelProvider().getText(desc);
                    return text == null ? FilteredTableBaseHandler.EMPTY_STRING : text;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FilteredTableItem) {
                    return ((FilteredTableItem)element).image;
                }
                if (element instanceof WorkbenchPartReference) {
                    return ((WorkbenchPartReference)element).getTitleImage();
                }
                if (element instanceof IPerspectiveDescriptor) {
                    IPerspectiveDescriptor desc = (IPerspectiveDescriptor)element;
                    return FilteredTableBaseHandler.this.getPerspectiveLabelProvider().getImage(desc);
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof FilteredTableItem) {
                    return ((FilteredTableItem)element).tooltipText;
                }
                if (element instanceof WorkbenchPartReference) {
                    return ((WorkbenchPartReference)element).getTitleToolTip();
                }
                return super.getToolTipText(element);
            }
        };
    }

    protected abstract Object getInput(WorkbenchPage var1);

    protected abstract ParameterizedCommand getBackwardCommand();

    protected abstract ParameterizedCommand getForwardCommand();

    protected String getTableHeader(IWorkbenchPart activePart) {
        return EMPTY_STRING;
    }

    public Object getSelection() {
        return this.selection;
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public TriggerSequence[] getBackwardTriggerSequences() {
        return this.backwardTriggerSequences;
    }

    public TriggerSequence[] getForwardTriggerSequences() {
        return this.forwardTriggerSequences;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.gotoDirection = data == null || "true".equals(data);
    }

    public class FilteredTableItem {
        String text;
        Image image;
        String tooltipText;
        Map<String, Object> dataMap = new HashMap<String, Object>();

        public void setText(String text) {
            this.text = text;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public void putData(String key, Object value) {
            this.dataMap.put(key, value);
        }

        public Object getData(String key) {
            return this.dataMap.get(key);
        }
    }
}

