/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration.ui.tabs;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.util.StandardWidgetToolkit;
import org.eclipse.efm.execution.core.Activator;
import org.eclipse.efm.execution.launchconfiguration.LaunchConfigurationTabGroup;
import org.eclipse.efm.execution.launchconfiguration.ui.tabs.OverviewTab;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSewLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationGUIelement {
    protected IWidgetToolkit fWidgetToolkit;
    protected LaunchConfigurationTabGroup fGroupTab;
    protected AbstractConfigurationPage fContentCompositeManager;

    public AbstractSewLaunchConfigurationTab(LaunchConfigurationTabGroup groupTab) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        this.fWidgetToolkit = new StandardWidgetToolkit();
        this.fGroupTab = groupTab;
        this.fContentCompositeManager = null;
    }

    public LaunchConfigurationTabGroup getGroupTab() {
        return this.fGroupTab;
    }

    public OverviewTab getOverviewTab() {
        return this.fGroupTab.getOverviewTab();
    }

    public AbstractConfigurationPage getConfigurationPage() {
        return this.fContentCompositeManager;
    }

    public AbstractConfigurationPage[] getConfigurationPages() {
        return this.fGroupTab.getConfigurationPages();
    }

    public void createControl(Composite parent) {
        this.fContentCompositeManager.createControl(parent, this.fWidgetToolkit);
        this.setControl((Control)this.fContentCompositeManager.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fContentCompositeManager.setDefaultFieldValues(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fContentCompositeManager.initializeFieldValuesFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fContentCompositeManager.applyUpdatesOnFieldValuesFrom(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        AbstractConfigurationPage.FieldValidationReturn fieldValidation = this.fContentCompositeManager.areFieldsValid(launchConfig);
        if (fieldValidation.areFieldsValid()) {
            this.setMessage(fieldValidation.getReason());
        } else {
            this.setErrorMessage(fieldValidation.getReason());
        }
        return fieldValidation.areFieldsValid();
    }

    public final IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    public IWidgetToolkit getWidgetToolkit() {
        return this.fWidgetToolkit;
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setWarningMessage(String warningmessage) {
        super.setWarningMessage(warningmessage);
    }

    public void setErrorMessage(String errormessage) {
        super.setErrorMessage(errormessage);
    }

    public void updateGUI() {
        this.updateLaunchConfigurationDialog();
    }

    public void scheduleUpdateJob() {
        super.scheduleUpdateJob();
    }
}

