/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.common.CommonFactory;
import org.eclipse.efm.execution.core.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationLimit;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationQueue;
import org.eclipse.efm.execution.core.workflow.common.GraphExplorationStrategyKind;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.RedundancyDetection;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.execution.core.workflow.impl.SupervisorWorkerImpl;

public class SupervisorWorkerCustomImpl
extends SupervisorWorkerImpl
implements IWorkflowConfigurationConstants {
    protected SupervisorWorkerCustomImpl() {
    }

    public static SupervisorWorkerCustomImpl create(ILaunchConfiguration configuration) {
        GraphExplorationStrategyKind strategy;
        SupervisorWorkerCustomImpl supervisor = new SupervisorWorkerCustomImpl();
        GraphExplorationLimit limit = CommonFactory.eINSTANCE.createGraphExplorationLimit();
        try {
            limit.setStep(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setStep(-1L);
        }
        try {
            limit.setEval(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_EVALS", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setEval(-1L);
        }
        try {
            limit.setNode(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setNode(-1L);
        }
        try {
            limit.setHeight(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setHeight(-1L);
        }
        try {
            limit.setWidth(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setWidth(-1L);
        }
        limit.setReport(-1L);
        limit.setSave(-1L);
        supervisor.setLimit(limit);
        GraphExplorationQueue queue = CommonFactory.eINSTANCE.createGraphExplorationQueue();
        try {
            strategy = GraphExplorationStrategyKind.get(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH.getLiteral()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            strategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
        }
        queue.setStrategy(strategy != null ? strategy : GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH);
        supervisor.setQueue(queue);
        ConsoleLogFormatCustomImpl console = ConsoleLogFormatCustomImpl.create("\\nstep:%1% , context:%2% , height:%3% , width:%4%", "\\nstop:%1% , context:%2% , height:%3% , width:%4%");
        supervisor.setConsole(console);
        return supervisor;
    }

    public static SupervisorWorkerCustomImpl createSecond(ILaunchConfiguration configuration) {
        GraphExplorationStrategyKind strategy;
        String strObjective;
        SupervisorWorkerCustomImpl supervisor = new SupervisorWorkerCustomImpl();
        try {
            strObjective = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_EXTENSION_OBJECTIVE", "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strObjective = "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strObjective == null || strObjective.isEmpty()) {
            strObjective = "output#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        TraceSpecificationCustomImpl extender = TraceSpecificationCustomImpl.create("extender", strObjective);
        extender.setDescription("Extension of Traces to reach observables for tests purpose");
        supervisor.setExtender(extender);
        GraphExplorationLimit limit = CommonFactory.eINSTANCE.createGraphExplorationLimit();
        try {
            limit.setStep(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_EXTENSION_EVALUATION_STEPS", -1));
        }
        catch (CoreException e) {
            e.printStackTrace();
            limit.setStep(-1L);
        }
        limit.setEval(-1L);
        limit.setNode(-1L);
        limit.setHeight(-1L);
        limit.setWidth(-1L);
        limit.setReport(-1L);
        limit.setSave(-1L);
        supervisor.setLimit(limit);
        GraphExplorationQueue queue = CommonFactory.eINSTANCE.createGraphExplorationQueue();
        try {
            strategy = GraphExplorationStrategyKind.get(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_ANALYZE_STRATEGY", GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH.getLiteral()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            strategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
        }
        queue.setStrategy(strategy != null ? strategy : GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH);
        supervisor.setQueue(queue);
        ConsoleLogFormatCustomImpl console = ConsoleLogFormatCustomImpl.create("\\nstep:%1% , context:%2% , height:%3% , width:%4%", "\\nstop:%1% , context:%2% , height:%3% , width:%4%");
        supervisor.setConsole(console);
        return supervisor;
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl extender;
        writer.commentLine(this.getComment());
        writer.appendTab("supervisor");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        if ((extender = (TraceSpecificationCustomImpl)this.getExtender()) != null) {
            extender.toWriter(writer2);
        }
        GraphExplorationLimit limit = this.getLimit();
        writer.appendTab2Eol("limit 'of graph exploration' [");
        writer.appendTab3("step = ").appendEol(limit.getStep());
        writer.appendTab3("eval = ").appendEol(limit.getEval());
        long value = -1L;
        value = limit.getNode();
        if (value >= 0L) {
            writer.appendTab3("node = ").appendEol(value);
        }
        if ((value = limit.getHeight()) >= 0L) {
            writer.appendTab3("height = ").appendEol(value);
        }
        if ((value = limit.getWidth()) >= 0L) {
            writer.appendTab3("width  = ").appendEol(value);
        }
        if ((value = limit.getReport()) >= 0L) {
            writer.appendTab3("report = ").appendEol(value);
        }
        if ((value = limit.getSave()) >= 0L) {
            writer.appendTab3("save   = ").appendEol(value);
        }
        writer.appendTab2Eol("] // end limit");
        GraphExplorationQueue queue = this.getQueue();
        writer.appendTab2Eol("queue 'defining the exploration/search strategy' [");
        int weight = queue.getWeight();
        boolean useHeuristic = queue.isHeuristic();
        writer.appendTab3("strategy = '");
        if (useHeuristic || weight > 0) {
            writer.append("WEIGHT#");
        }
        writer.append(queue.getStrategy().getLiteral()).appendEol("'");
        if (weight > 0) {
            writer.appendTab3("weight = ").appendEol(weight);
        }
        if (useHeuristic) {
            writer.appendTab3Eol("heuristic = true");
        }
        writer.appendTab2Eol("] // end queue");
        writer.appendTab2Eol("redundancy 'detection strategy' [");
        RedundancyDetection redundancy = this.getRedundancy();
        if (redundancy != null) {
            str = redundancy.getComparer();
            if (str != null) {
                writer.appendTab3("comparer = '").append(str).appendEol("'");
                str = redundancy.getSolver();
                if (str == null) {
                    str = "OMEGA";
                }
                writer.appendTab3("solver = '").append(str).appendEol("'");
                str = redundancy.getPathScope();
                if (str == null) {
                    str = "CURRENT";
                }
                writer.appendTab3("path_scope = '").append(str).appendEol("'");
                str = redundancy.getDataScope();
                if (str == null) {
                    str = "ALL";
                }
                writer.appendTab3("data_scope = '").append(str).appendEol("'");
            } else {
                writer.appendTab3("loop#detection#trivial = ").appendEol(redundancy.isLoopDetetctionTrivial());
            }
        } else {
            writer.appendTab3Eol("loop#detection#trivial = true");
        }
        writer.appendTab2Eol("] // end redundancy");
        ConsoleLogFormatCustomImpl console = (ConsoleLogFormatCustomImpl)this.getConsole();
        if (console != null) {
            console.toWriter(writer.itab2());
        }
        writer.appendTabEol("}");
    }
}

