/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GraphExplorationStrategyKind implements Enumerator
{
    BEST_FIRST_SEARCH(0, "BEST_FIRST_SEARCH", "BEST_FIRST_SEARCH"),
    BREADTH_FIRST_SEARCH(1, "BREADTH_FIRST_SEARCH", "BREADTH_FIRST_SEARCH"),
    DEPTH_FIRST_SEARCH(2, "DEPTH_FIRST_SEARCH", "DEPTH_FIRST_SEARCH"),
    RANDOM_FIRST_SEARCH(3, "RANDOM_FIRST_SEARCH", "RANDOM_FIRST_SEARCH"),
    XFS(4, "XFS", "XFS"),
    FIRST(5, "FIRST", "FIRST"),
    LAST(6, "LAST", "LAST"),
    ALL(7, "ALL", "ALL");

    public static final int BEST_FIRST_SEARCH_VALUE = 0;
    public static final int BREADTH_FIRST_SEARCH_VALUE = 1;
    public static final int DEPTH_FIRST_SEARCH_VALUE = 2;
    public static final int RANDOM_FIRST_SEARCH_VALUE = 3;
    public static final int XFS_VALUE = 4;
    public static final int FIRST_VALUE = 5;
    public static final int LAST_VALUE = 6;
    public static final int ALL_VALUE = 7;
    private static final GraphExplorationStrategyKind[] VALUES_ARRAY;
    public static final List<GraphExplorationStrategyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GraphExplorationStrategyKind[]{BEST_FIRST_SEARCH, BREADTH_FIRST_SEARCH, DEPTH_FIRST_SEARCH, RANDOM_FIRST_SEARCH, XFS, FIRST, LAST, ALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GraphExplorationStrategyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GraphExplorationStrategyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GraphExplorationStrategyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GraphExplorationStrategyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GraphExplorationStrategyKind get(int value) {
        switch (value) {
            case 0: {
                return BEST_FIRST_SEARCH;
            }
            case 1: {
                return BREADTH_FIRST_SEARCH;
            }
            case 2: {
                return DEPTH_FIRST_SEARCH;
            }
            case 3: {
                return RANDOM_FIRST_SEARCH;
            }
            case 4: {
                return XFS;
            }
            case 5: {
                return FIRST;
            }
            case 6: {
                return LAST;
            }
            case 7: {
                return ALL;
            }
        }
        return null;
    }

    private GraphExplorationStrategyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

