/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.editors.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractSectionPart {
    private List<FieldEditor> fFields = null;
    private Composite fSection = null;
    private Composite fSectionClient = null;

    public abstract String getSectionTitle();

    public abstract String getSectionDescription();

    public Composite getSection() {
        return this.fSection;
    }

    public void setSection(Composite section) {
        this.fSection = section;
    }

    public Composite getSectionClient() {
        return this.fSectionClient;
    }

    public void setSectionClient(Composite sectionClient) {
        this.fSectionClient = sectionClient;
    }

    public Composite getControl() {
        return this.fSection;
    }

    protected void addField(FieldEditor editor) {
        if (this.fFields == null) {
            this.fFields = new ArrayList<FieldEditor>();
        }
        this.fFields.add(editor);
    }

    public List<FieldEditor> getFieldEditors() {
        return this.fFields;
    }

    protected abstract void setDefaultsImpl(ILaunchConfigurationWorkingCopy var1);

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fFields != null) {
            for (FieldEditor fieldEditor : this.fFields) {
                fieldEditor.setDefaults(configuration);
            }
        }
        this.setDefaultsImpl(configuration);
    }

    protected abstract void initializeFromImpl(ILaunchConfiguration var1);

    public final void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fFields != null) {
            for (FieldEditor fieldEditor : this.fFields) {
                fieldEditor.initializeFrom(configuration);
            }
        }
        this.initializeFromImpl(configuration);
    }

    protected abstract void performApplyImpl(ILaunchConfigurationWorkingCopy var1);

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fFields != null) {
            for (FieldEditor fieldEditor : this.fFields) {
                fieldEditor.performApply(configuration);
            }
        }
        this.performApplyImpl(configuration);
    }

    protected abstract boolean isValidImpl(ILaunchConfiguration var1);

    public final boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.isValidImpl(launchConfig)) {
            if (this.fFields != null) {
                for (FieldEditor fieldEditor : this.fFields) {
                    if (fieldEditor.isValid()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void handleConfigurationPropertyChange(PropertyChangeEvent event) {
    }
}

