/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationSection;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewBehaviorSelectionConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewExplorationConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewTestOfflineConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewTransitionCoverageConfigurationProfile;
import org.eclipse.efm.ui.utils.ImageResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OverviewAnalysisProfileSection
extends AbstractConfigurationSection {
    protected CTabFolder fTabFolder;
    protected CTabItem fExplorationTabItem;
    protected CTabItem fTransitionCoverageTabItem;
    protected CTabItem fBehaviorSelectionTabItem;
    protected CTabItem fTestOfflineTabItem;
    protected CTabItem fModelAnalysisProfileSelectionTabItem;
    public OverviewExplorationConfigurationProfile fExplorationPage;
    public OverviewTransitionCoverageConfigurationProfile fTransitionCoveragePage;
    public OverviewBehaviorSelectionConfigurationProfile fBehaviorSelectionPage;
    public OverviewTestOfflineConfigurationProfile fTestOfflinePage;
    private String fModelAnalysisProfile = "Exploration";

    public OverviewAnalysisProfileSection(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
        this.fExplorationPage = new OverviewExplorationConfigurationProfile(configurationPage);
        this.fTransitionCoveragePage = new OverviewTransitionCoverageConfigurationProfile(configurationPage, this);
        this.fBehaviorSelectionPage = new OverviewBehaviorSelectionConfigurationProfile(configurationPage);
        this.fTestOfflinePage = this.getConfigurationPage().isEnabledSymbexIncubationMode() ? new OverviewTestOfflineConfigurationProfile(configurationPage) : null;
    }

    @Override
    public String getSectionTitle() {
        return "Analysis Profile";
    }

    @Override
    public String getSectionDescription() {
        return "Select the analysis profile of the model by selecting a tab";
    }

    public boolean isTransitionCoverage() {
        return this.fModelAnalysisProfile.equals("Transition Coverage");
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fTabFolder = widgetToolkit.createTabFolder(parent, 128);
        this.fTabFolder.setToolTipText("Choice of the strategy for the symbolic execution of the model\n\t- Exploration: basic symbolic execution of the model\n\t- Transition Coverage: compute a symbolic tree which covers all transitions of the model\n\t- Behavior Selection: compute one or more symbolic path(s) which cover(s)\n\t\t\t   a predefined behavior\n\t- TESTOFFLINE : Test Verdict Computation: Offline testing...\n");
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        this.fTabFolder.setLayoutData((Object)gd);
        this.createExplorationTabItem(widgetToolkit);
        this.createTransitionCoverageTabItem(widgetToolkit);
        this.createBehaviorSelectionTabItem(widgetToolkit);
        if (this.getConfigurationPage().isEnabledSymbexIncubationMode()) {
            this.createTestOfflineTabItem(widgetToolkit);
        } else {
            this.fTestOfflineTabItem = null;
        }
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewAnalysisProfileSection.this.handleModelAnalysisProfileSelectionChange();
                OverviewAnalysisProfileSection.this.fConfigurationPage.propertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", (Object)OverviewAnalysisProfileSection.this.fModelAnalysisProfile, (Object)OverviewAnalysisProfileSection.this.fModelAnalysisProfile));
                OverviewAnalysisProfileSection.this.fConfigurationPage.propagateUpdateJobScheduling();
            }
        });
    }

    private void createExplorationTabItem(IWidgetToolkit widgetToolkit) {
        this.fExplorationTabItem = new CTabItem(this.fTabFolder, 0);
        this.fExplorationTabItem.setText("Exploration");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        this.fExplorationPage.createControl((Composite)scrolledComposite, widgetToolkit);
        Composite control = this.fExplorationPage.getControl();
        if (control != null) {
            scrolledComposite.setContent((Control)control);
            this.fExplorationTabItem.setControl((Control)scrolledComposite);
        }
    }

    private void createTransitionCoverageTabItem(IWidgetToolkit widgetToolkit) {
        this.fTransitionCoverageTabItem = new CTabItem(this.fTabFolder, 0);
        this.fTransitionCoverageTabItem.setText("Transition Coverage");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        this.fTransitionCoveragePage.createControl((Composite)scrolledComposite, widgetToolkit);
        Composite control = this.fTransitionCoveragePage.getControl();
        if (control != null) {
            scrolledComposite.setContent((Control)control);
            this.fTransitionCoverageTabItem.setControl((Control)scrolledComposite);
        }
    }

    private void createBehaviorSelectionTabItem(IWidgetToolkit widgetToolkit) {
        this.fBehaviorSelectionTabItem = new CTabItem(this.fTabFolder, 0);
        this.fBehaviorSelectionTabItem.setText("Behavior Selection");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        this.fBehaviorSelectionPage.createControl((Composite)scrolledComposite, widgetToolkit);
        Composite control = this.fBehaviorSelectionPage.getControl();
        if (control != null) {
            scrolledComposite.setContent((Control)control);
            this.fBehaviorSelectionTabItem.setControl((Control)scrolledComposite);
        }
    }

    private void createTestOfflineTabItem(IWidgetToolkit widgetToolkit) {
        this.fTestOfflineTabItem = new CTabItem(this.fTabFolder, 0);
        this.fTestOfflineTabItem.setText("Test Offline");
        ScrolledComposite scrolledComposite = widgetToolkit.createScrolledComposite((Composite)this.fTabFolder);
        this.fTestOfflinePage.createControl((Composite)scrolledComposite, widgetToolkit);
        Composite control = this.fTestOfflinePage.getControl();
        if (control != null) {
            scrolledComposite.setContent((Control)control);
            this.fTestOfflineTabItem.setControl((Control)scrolledComposite);
        }
    }

    /*
     * Exception decompiling
     */
    public void setVisibleModelAnalysisProfilePage(String profile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl41 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl41 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleModelAnalysisProfileSelectionChange() {
        if (this.fModelAnalysisProfileSelectionTabItem != null) {
            this.fModelAnalysisProfileSelectionTabItem.setImage(null);
        }
        this.fModelAnalysisProfileSelectionTabItem = this.fTabFolder.getItem(this.fTabFolder.getSelectionIndex());
        this.fModelAnalysisProfile = this.fModelAnalysisProfileSelectionTabItem.getText();
        this.fModelAnalysisProfileSelectionTabItem.setImage(ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/validate.gif"));
    }

    @Override
    public void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", "Exploration");
        this.fExplorationPage.setDefaults(configuration);
        this.fTransitionCoveragePage.setDefaults(configuration);
        this.fBehaviorSelectionPage.setDefaults(configuration);
        if (this.fTestOfflinePage != null) {
            this.fTestOfflinePage.setDefaults(configuration);
        }
    }

    @Override
    public void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            this.fModelAnalysisProfile = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", "Exploration");
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.fModelAnalysisProfile = "Exploration";
        }
        this.setVisibleModelAnalysisProfilePage(this.fModelAnalysisProfile);
        this.fConfigurationPage.propagateGUIupdate();
        this.fExplorationPage.initializeFrom(configuration);
        this.fTransitionCoveragePage.initializeFrom(configuration);
        this.fBehaviorSelectionPage.initializeFrom(configuration);
        if (this.fTestOfflinePage != null) {
            this.fTestOfflinePage.initializeFrom(configuration);
        }
    }

    @Override
    public void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", this.fModelAnalysisProfile);
        this.fExplorationPage.performApply(configuration);
        this.fTransitionCoveragePage.performApply(configuration);
        this.fBehaviorSelectionPage.performApply(configuration);
        if (this.fTestOfflinePage != null) {
            this.fTestOfflinePage.performApply(configuration);
        }
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        switch (this.fModelAnalysisProfile) {
            case "Exploration": {
                if (this.fExplorationPage.isValid(launchConfig)) break;
                return false;
            }
            case "Behavior Selection": {
                if (this.fBehaviorSelectionPage.isValid(launchConfig)) break;
                return false;
            }
            case "Transition Coverage": {
                if (this.fTransitionCoveragePage.isValid(launchConfig)) break;
                return false;
            }
            case "Test Offline": {
                if (this.fTestOfflinePage == null || this.fTestOfflinePage.isValid(launchConfig)) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        this.fExplorationPage.handleConfigurationPropertyChange(event);
        this.fTransitionCoveragePage.handleConfigurationPropertyChange(event);
        this.fBehaviorSelectionPage.handleConfigurationPropertyChange(event);
        if (this.fTestOfflinePage != null) {
            this.fTestOfflinePage.handleConfigurationPropertyChange(event);
        }
    }
}

