/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.m2e.core.internal.embedder.AbstractTransferListenerAdapter;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;

public class ArtifactTransferListenerAdapter
extends AbstractTransferListenerAdapter
implements TransferListener {
    ArtifactTransferListenerAdapter(MavenImpl maven, IProgressMonitor monitor) {
        super(maven, monitor);
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        try {
            this.transferInitiated(String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName());
        }
        catch (OperationCanceledException e) {
            throw new TransferCancelledException();
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        long total = event.getResource().getContentLength();
        String artifactUrl = String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName();
        try {
            this.transferProgress(artifactUrl, total, event.getDataBuffer().remaining());
        }
        catch (OperationCanceledException e) {
            throw new TransferCancelledException();
        }
    }

    public void transferStarted(TransferEvent event) {
        this.transferStarted(String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName());
    }

    public void transferCorrupted(TransferEvent event) {
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName());
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName());
    }
}

