/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WSash;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseSashRenderer<N>
extends BaseRenderer<MPartSashContainer, WSash<N>> {
    @Inject
    RendererFactory factory;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPartSashContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartSashContainer && BaseSashRenderer.this == (parent = (MPartSashContainer)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseSashRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseSashRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MPartSashContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartSashContainer && BaseSashRenderer.this == (parent = (MPartSashContainer)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseSashRenderer.this.handleSelectedElement(parent, (MPartSashContainerElement)oldValue, (MPartSashContainerElement)newValue);
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                MElementContainer parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = changedObj.getParent()) != null && BaseSashRenderer.this == parent.getRenderer()) {
                    MPartSashContainer stack = (MPartSashContainer)parent;
                    String eventType = (String)event.getProperty("EventType");
                    if ("SET".equals(eventType)) {
                        Boolean newValue = (Boolean)event.getProperty("NewValue");
                        if (newValue.booleanValue()) {
                            BaseSashRenderer.this.childRendered(stack, changedObj);
                        } else {
                            BaseSashRenderer.this.hideChild(stack, changedObj);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void doProcessContent(MPartSashContainer element) {
        WSash sash = (WSash)this.getWidget((MUIElement)element);
        ArrayList<WLayoutedWidget<MPartSashContainerElement>> list = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        for (MPartSashContainerElement e : element.getChildren()) {
            WLayoutedWidget widget;
            if (!e.isToBeRendered() || (widget = (WLayoutedWidget)this.engineCreateWidget(e)) == null || !e.isVisible()) continue;
            list.add(widget);
        }
        sash.addItems(list);
    }

    public void childRendered(MPartSashContainer parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WSash sash = (WSash)this.getWidget((MUIElement)parentElement);
        List<WLayoutedWidget<MPartSashContainerElement>> l = Collections.singletonList((WLayoutedWidget)element.getWidget());
        sash.addItems(idx, l);
    }

    public void hideChild(MPartSashContainer container, MUIElement changedObj) {
        WSash sash = (WSash)this.getWidget((MUIElement)container);
        if (sash == null) {
            return;
        }
        WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
        if (widget != null) {
            sash.removeItem(widget);
        }
    }

    void handleChildrenAddition(MPartSashContainer parent, Collection<MPartSashContainerElement> elements) {
        for (MPartSashContainerElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    void handleChildrenRemove(MPartSashContainer parent, Collection<MPartSashContainerElement> elements) {
        for (MPartSashContainerElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    void handleSelectedElement(MPartSashContainer parent, MPartSashContainerElement oldElement, MPartSashContainerElement newElement) {
    }
}

