/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.key;

import javafx.scene.input.KeyEvent;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.keybindings.service.BindingFactory;

public class FxKeySupport {
    public static int convertEventToUnmodifiedAccelerator(KeyEvent event) {
        int modifiers = FxKeySupport.getStateMask(event) & 0x470000;
        return modifiers + event.getCode().impl_getCode();
    }

    public static final int convertEventToUnshiftedModifiedAccelerator(KeyEvent event) {
        if (Character.isLetter(event.getCharacter().charAt(0))) {
            return FxKeySupport.convertEventToUnmodifiedAccelerator(event);
        }
        int modifiers = FxKeySupport.getStateMask(event) & 0x450000;
        return modifiers + event.getCode().impl_getCode();
    }

    public static final int convertEventToModifiedAccelerator(KeyEvent event) {
        int modifiers = FxKeySupport.getStateMask(event) & 0x470000;
        return modifiers + event.getCode().impl_getCode();
    }

    public static int getStateMask(KeyEvent event) {
        int rv = 0;
        if (event.isAltDown()) {
            rv |= 0x10000;
        }
        if (event.isControlDown()) {
            rv |= 0x40000;
        }
        if (event.isShiftDown()) {
            rv |= 0x20000;
        }
        if (event.isMetaDown()) {
            rv |= 0x400000;
        }
        return rv;
    }

    public static KeyStroke convertAcceleratorToKeyStroke(BindingFactory factory, KeyLookup lookup, int accelerator) {
        int modifierKeys = accelerator & 0x470000;
        int naturalKey = accelerator == modifierKeys ? 0 : accelerator - modifierKeys;
        return factory.getKeyStrokeInstance(lookup, modifierKeys, naturalKey);
    }
}

