/**
 * generated by Xtext
 */
package org.eclipse.fx.code.editor.ldef.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.code.editor.ldef.generator.JavaFXCodeGenerator;
import org.eclipse.fx.code.editor.ldef.lDef.CodeIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Integration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaFXIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.Root;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class LDefGenerator implements IGenerator {
  @Inject
  private JavaFXCodeGenerator generator;
  
  public void doGenerate(final Resource resource, final IFileSystemAccess fsa) {
    EList<EObject> _contents = resource.getContents();
    EObject _head = IterableExtensions.<EObject>head(_contents);
    final Root root = ((Root) _head);
    LanguageDef _languageDefinition = root.getLanguageDefinition();
    Integration _integration = _languageDefinition.getIntegration();
    boolean _notEquals = (!Objects.equal(_integration, null));
    if (_notEquals) {
      LanguageDef _languageDefinition_1 = root.getLanguageDefinition();
      Integration _integration_1 = _languageDefinition_1.getIntegration();
      EList<CodeIntegration> _codeIntegrationList = _integration_1.getCodeIntegrationList();
      Iterable<JavaFXIntegration> _filter = Iterables.<JavaFXIntegration>filter(_codeIntegrationList, JavaFXIntegration.class);
      boolean _isEmpty = IterableExtensions.isEmpty(_filter);
      boolean _not = (!_isEmpty);
      if (_not) {
        LanguageDef _languageDefinition_2 = root.getLanguageDefinition();
        this.generator.generate(_languageDefinition_2, fsa);
      }
    }
  }
}
