/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.fxml;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.eclipse.fx.core.fxml.FXMLDocument;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExtendedFXMLLoader {
    public static <T> @NonNull T load(@NonNull ClassLoader cl, @NonNull String path) throws IOException {
        return ExtendedFXMLLoader.load(cl, null, path);
    }

    public static <T> @NonNull T load(@NonNull ClassLoader cl, @Nullable ResourceBundle resourceBundle, @NonNull String path) throws IOException {
        return (T)ExtendedFXMLLoader.loadWithController(cl, resourceBundle, null, path).getNode();
    }

    public static <T> @NonNull T load(@NonNull ClassLoader cl, @Nullable ResourceBundle resourceBundle, T root, @NonNull String path) throws IOException {
        return (T)ExtendedFXMLLoader.loadWithController(cl, resourceBundle, root, null, path).getNode();
    }

    public static <N, C> Data<N, C> loadWithController(@NonNull ClassLoader cl, @Nullable ResourceBundle resourceBundle, @Nullable Callback<Class<?>, Object> controllerFactory, @NonNull String path) throws IOException {
        return ExtendedFXMLLoader.loadWithController(cl, resourceBundle, null, controllerFactory, path);
    }

    public static <N, D extends N, C> @NonNull Data<N, C> loadWithController(@NonNull ClassLoader cl, @Nullable ResourceBundle resourceBundle, @Nullable D root, @Nullable Callback<Class<?>, Object> controllerFactory, @NonNull String path) throws IOException {
        try {
            String classname = path.substring(0, path.lastIndexOf(46)).replace('/', '.');
            Class<?> clazz = cl.loadClass(classname);
            final FXMLDocument d = (FXMLDocument)clazz.newInstance();
            URL url = cl.getResource(path);
            if (url != null) {
                final D n = d.load(new FXMLDocument.LoadData<D>(url, resourceBundle, root, controllerFactory));
                return new Data<N, C>(){

                    @Override
                    public N getNode() {
                        return n;
                    }

                    @Override
                    public C getController() {
                        return d.getController();
                    }
                };
            }
            throw new IOException("Unable to get url for path '" + path + "'");
        }
        catch (ClassNotFoundException classNotFoundException) {
            final FXMLLoader loader = new FXMLLoader();
            loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
            loader.setResources(resourceBundle);
            loader.setLocation(cl.getResource(path));
            loader.setControllerFactory(controllerFactory);
            final Object rv = loader.load(cl.getResourceAsStream(path));
            if (rv != null) {
                return new Data<N, C>(){

                    @Override
                    public N getNode() {
                        return rv;
                    }

                    @Override
                    public C getController() {
                        return loader.getController();
                    }
                };
            }
            throw new IOException("Unable to load fxml document from '" + path + "'");
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public static interface Data<N, C> {
        public @NonNull N getNode();

        public @Nullable C getController();
    }
}

