/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.fxgraph.converter.IFXMLFile;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FXGraphFactory;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceType;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StringValue;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.fxml.compiler.ReflectionHelper;
import org.eclipse.fx.ide.fxml.compiler.ValueType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXMLSaxHandler
extends DefaultHandler {
    public Model model;
    private Stack<Object> stack = new Stack();
    private final IJvmTypeProvider provider;
    private final Map<String, String> simpleToFqn;
    private final List<String> globalImports;
    private IFXMLFile file;
    private Map<String, Element> idMap = new HashMap<String, Element>();
    private boolean valueOfType = false;
    private static String FXML_NAMESPACE = "http://javafx.com/fxml";
    private static String FXML_NAMESPACE_1 = "http://javafx.com/fxml/1";

    @Inject
    public FXMLSaxHandler(IJvmTypeProvider.Factory jdtTypeProviderFactory) {
        this.provider = jdtTypeProviderFactory.createTypeProvider();
        ArrayList<String> _arrayList = new ArrayList<String>();
        this.globalImports = _arrayList;
        HashMap<String, String> _hashMap = new HashMap<String, String>();
        this.simpleToFqn = _hashMap;
        this.globalImports.add("java.lang");
    }

    public IFXMLFile setFile(IFXMLFile file) {
        this.file = file;
        return this.file;
    }

    @Override
    public void startDocument() throws SAXException {
        this.model = FXGraphFactory.eINSTANCE.createModel();
        PackageDeclaration pack = FXGraphFactory.eINSTANCE.createPackageDeclaration();
        String _packagename = null;
        if (this.file != null) {
            _packagename = this.file.getPackagename();
        }
        pack.setName(_packagename);
        this.model.setPackage(pack);
        ComponentDefinition componentDef = FXGraphFactory.eINSTANCE.createComponentDefinition();
        String _name = null;
        if (this.file != null) {
            _name = this.file.getName();
        }
        String _name_1 = null;
        if (this.file != null) {
            _name_1 = this.file.getName();
        }
        componentDef.setName(_name.substring(0, _name_1.indexOf(".")));
        this.model.setComponentDef(componentDef);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        boolean _equals = Objects.equal((Object)"import", (Object)target);
        if (_equals) {
            boolean _not;
            Import i = FXGraphFactory.eINSTANCE.createImport();
            i.setImportedNamespace(data);
            EList _imports = this.model.getImports();
            _imports.add((Object)i);
            boolean _endsWith = i.getImportedNamespace().endsWith("*");
            boolean bl = _not = !_endsWith;
            if (_not) {
                String _importedNamespace = i.getImportedNamespace();
                int _lastIndexOf = i.getImportedNamespace().lastIndexOf(".");
                int _plus = _lastIndexOf + 1;
                this.simpleToFqn.put(_importedNamespace.substring(_plus), i.getImportedNamespace());
            } else {
                this.globalImports.add(i.getImportedNamespace().substring(0, i.getImportedNamespace().lastIndexOf(".")));
            }
        }
    }

    public String getFXAttributeValue(Attributes attributes, String name) {
        String v = attributes.getValue(FXML_NAMESPACE, name);
        boolean _equals = Objects.equal((Object)v, null);
        if (_equals) {
            v = attributes.getValue(FXML_NAMESPACE_1, name);
        }
        return v;
    }

    public boolean isFXNamedSpace(String uri) {
        return Objects.equal((Object)uri, (Object)FXML_NAMESPACE) || Objects.equal((Object)uri, (Object)FXML_NAMESPACE_1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.isFXNamedSpace(uri) && localName.contains(".")) {
            Object _peek = this.stack.peek();
            Element e = (Element)_peek;
            StaticCallValueProperty prop = FXGraphFactory.eINSTANCE.createStaticCallValueProperty();
            int _indexOf = localName.indexOf(".");
            int _plus = _indexOf + 1;
            prop.setName(localName.substring(_plus));
            JvmParameterizedTypeReference t = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            t.setType(this.provider.findTypeByName(ReflectionHelper.getFqnType(localName.substring(0, localName.indexOf(".")), this.simpleToFqn, this.globalImports)));
            prop.setType((JvmTypeReference)t);
            e.getStaticCallProperties().add((Object)prop);
            this.stack.push(prop);
        } else if (!this.isFXNamedSpace(uri) && Character.isLowerCase(localName.charAt(0))) {
            Object _peek_1 = this.stack.peek();
            Element e_1 = (Element)_peek_1;
            Property prop_1 = FXGraphFactory.eINSTANCE.createProperty();
            prop_1.setName(localName);
            ValueType vt = ReflectionHelper.getValueType(e_1.getType().getType(), localName);
            boolean _equals = Objects.equal((Object)((Object)vt), (Object)((Object)ValueType.LIST));
            if (_equals) {
                ListValueProperty lp = FXGraphFactory.eINSTANCE.createListValueProperty();
                prop_1.setValue((ValueProperty)lp);
            }
            EList _properties = e_1.getProperties();
            _properties.add((Object)prop_1);
            this.stack.push(prop_1);
        } else {
            boolean _equals_1;
            boolean _notEquals;
            String _fXAttributeValue = this.getFXAttributeValue(attributes, "value");
            boolean bl = _notEquals = !Objects.equal((Object)_fXAttributeValue, null);
            if (_notEquals) {
                Object _peek_2 = this.stack.peek();
                Property p = (Property)_peek_2;
                ValueProperty _value = p.getValue();
                ListValueProperty lp_1 = (ListValueProperty)_value;
                SimpleValueProperty vp = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                vp.setStringValue(this.getFXAttributeValue(attributes, "value"));
                EList _value_1 = lp_1.getValue();
                _value_1.add((Object)vp);
                this.valueOfType = true;
                return;
            }
            Element e_2 = FXGraphFactory.eINSTANCE.createElement();
            boolean isDynRoot = Objects.equal((Object)localName, (Object)"root") && this.isFXNamedSpace(uri);
            JvmParameterizedTypeReference t_1 = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            if (isDynRoot) {
                ComponentDefinition _componentDef = this.model.getComponentDef();
                _componentDef.setDynamicRoot(true);
                t_1.setType(this.provider.findTypeByName(ReflectionHelper.getFqnType(attributes.getValue("type"), this.simpleToFqn, this.globalImports)));
            } else {
                t_1.setType(this.provider.findTypeByName(ReflectionHelper.getFqnType(localName, this.simpleToFqn, this.globalImports)));
            }
            e_2.setType((JvmTypeReference)t_1);
            int i = 0;
            while (i < attributes.getLength()) {
                boolean _isFXNamedSpace = this.isFXNamedSpace(attributes.getURI(i));
                if (_isFXNamedSpace) {
                    _equals_1 = "id".equals(attributes.getLocalName(i));
                    if (_equals_1) {
                        e_2.setName(attributes.getValue(i));
                        this.idMap.put(e_2.getName(), e_2);
                    } else {
                        boolean _equals_2 = "controller".equals(attributes.getLocalName(i));
                        if (_equals_2) {
                            JvmParameterizedTypeReference ct = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
                            ct.setType(this.provider.findTypeByName(ReflectionHelper.getFqnType(attributes.getValue(i), this.simpleToFqn, this.globalImports)));
                            ComponentDefinition _componentDef_1 = this.model.getComponentDef();
                            _componentDef_1.setController((JvmTypeReference)ct);
                        }
                    }
                } else {
                    boolean _not;
                    boolean _contains = attributes.getLocalName(i).contains(".");
                    boolean bl2 = _not = !_contains;
                    if (_not) {
                        boolean _startsWith = attributes.getValue(i).startsWith("%");
                        if (_startsWith) {
                            ResourceValueProperty vp_1 = FXGraphFactory.eINSTANCE.createResourceValueProperty();
                            StringValue sv = FXGraphFactory.eINSTANCE.createStringValue();
                            sv.setValue(attributes.getValue(i).substring(1));
                            vp_1.setValue(sv);
                            Property pp = FXGraphFactory.eINSTANCE.createProperty();
                            pp.setName(attributes.getLocalName(i));
                            pp.setValue((ValueProperty)vp_1);
                            EList _properties_1 = e_2.getProperties();
                            _properties_1.add((Object)pp);
                        } else {
                            boolean _startsWith_1 = attributes.getValue(i).startsWith("@");
                            if (_startsWith_1) {
                                LocationValueProperty vp_2 = FXGraphFactory.eINSTANCE.createLocationValueProperty();
                                vp_2.setValue(attributes.getValue(i).substring(1));
                                Property pp_1 = FXGraphFactory.eINSTANCE.createProperty();
                                pp_1.setName(attributes.getLocalName(i));
                                pp_1.setValue((ValueProperty)vp_2);
                                EList _properties_2 = e_2.getProperties();
                                _properties_2.add((Object)pp_1);
                            } else {
                                boolean _startsWith_2 = attributes.getValue(i).startsWith("$");
                                if (_startsWith_2) {
                                    boolean _notEquals_1;
                                    String v = attributes.getValue(i).substring(1);
                                    Element ref = this.idMap.get(v);
                                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)ref, null);
                                    if (_notEquals_1) {
                                        ReferenceValueProperty vp_3 = FXGraphFactory.eINSTANCE.createReferenceValueProperty();
                                        vp_3.setReference((ReferenceType)ref);
                                        Property pp_2 = FXGraphFactory.eINSTANCE.createProperty();
                                        pp_2.setName(attributes.getLocalName(i));
                                        pp_2.setValue((ValueProperty)vp_3);
                                        EList _properties_3 = e_2.getProperties();
                                        _properties_3.add((Object)pp_2);
                                    }
                                } else if (!isDynRoot || !Objects.equal((Object)"type", (Object)attributes.getLocalName(i))) {
                                    String _qualifiedName = t_1.getType().getQualifiedName();
                                    boolean _equals_3 = Objects.equal((Object)"javafx.scene.image.Image", (Object)_qualifiedName);
                                    if (_equals_3) {
                                        String attname = attributes.getLocalName(i);
                                        SimpleValueProperty vp_4 = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                                        if (Objects.equal((Object)"requestedWidth", (Object)attname) || Objects.equal((Object)"requestedHeight", (Object)attname)) {
                                            vp_4.setNumber(attributes.getValue(i));
                                        } else if (Objects.equal((Object)"preserveRatio", (Object)attname) || Objects.equal((Object)"smooth", (Object)attname) || Objects.equal((Object)"backgroundLoading", (Object)attname)) {
                                            vp_4.setBooleanValue(attributes.getValue(i));
                                        }
                                        Property pp_3 = FXGraphFactory.eINSTANCE.createProperty();
                                        pp_3.setName(attributes.getLocalName(i));
                                        pp_3.setValue((ValueProperty)vp_4);
                                        EList _properties_4 = e_2.getProperties();
                                        _properties_4.add((Object)pp_3);
                                    } else {
                                        ValueType vt_1 = ReflectionHelper.getValueType(t_1.getType(), attributes.getLocalName(i));
                                        boolean _equals_4 = Objects.equal((Object)((Object)vt_1), (Object)((Object)ValueType.EVENT_CLASS));
                                        if (_equals_4) {
                                            ControllerHandledValueProperty vp_5 = FXGraphFactory.eINSTANCE.createControllerHandledValueProperty();
                                            vp_5.setMethodname(attributes.getValue(i).substring(1));
                                            Property pp_4 = FXGraphFactory.eINSTANCE.createProperty();
                                            pp_4.setName(attributes.getLocalName(i));
                                            pp_4.setValue((ValueProperty)vp_5);
                                            EList _properties_5 = e_2.getProperties();
                                            _properties_5.add((Object)pp_4);
                                        } else {
                                            boolean _equals_5 = Objects.equal((Object)((Object)vt_1), (Object)((Object)ValueType.LIST));
                                            if (_equals_5) {
                                                final ListValueProperty vp_6 = FXGraphFactory.eINSTANCE.createListValueProperty();
                                                Consumer<String> _function = new Consumer<String>(){

                                                    @Override
                                                    public void accept(String v) {
                                                        SimpleValueProperty lv = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                                                        lv.setStringValue(v);
                                                        EList _value = vp_6.getValue();
                                                        _value.add((Object)lv);
                                                    }
                                                };
                                                ((List)Conversions.doWrapArray((Object)attributes.getValue(i).split(","))).forEach(_function);
                                                Property pp_5 = FXGraphFactory.eINSTANCE.createProperty();
                                                pp_5.setName(attributes.getLocalName(i));
                                                pp_5.setValue((ValueProperty)vp_6);
                                                EList _properties_6 = e_2.getProperties();
                                                _properties_6.add((Object)pp_5);
                                            } else {
                                                SimpleValueProperty vp_7 = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                                                boolean _equals_6 = Objects.equal((Object)((Object)vt_1), (Object)((Object)ValueType.BOOLEAN));
                                                if (_equals_6) {
                                                    vp_7.setBooleanValue(attributes.getValue(i));
                                                } else {
                                                    boolean _equals_7 = Objects.equal((Object)((Object)vt_1), (Object)((Object)ValueType.NUMBER));
                                                    if (_equals_7) {
                                                        vp_7.setNumber(attributes.getValue(i));
                                                    } else {
                                                        vp_7.setStringValue(attributes.getValue(i));
                                                    }
                                                }
                                                Property pp_6 = FXGraphFactory.eINSTANCE.createProperty();
                                                pp_6.setName(attributes.getLocalName(i));
                                                pp_6.setValue((ValueProperty)vp_7);
                                                EList _properties_7 = e_2.getProperties();
                                                _properties_7.add((Object)pp_6);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        boolean _startsWith_3 = attributes.getValue(i).startsWith("$");
                        if (_startsWith_3) {
                            boolean _notEquals_2;
                            String v_1 = attributes.getValue(i).substring(1);
                            Element ref_1 = this.idMap.get(v_1);
                            boolean bl4 = _notEquals_2 = !Objects.equal((Object)ref_1, null);
                            if (_notEquals_2) {
                                ReferenceValueProperty vp_8 = FXGraphFactory.eINSTANCE.createReferenceValueProperty();
                                vp_8.setReference((ReferenceType)ref_1);
                                StaticCallValueProperty pp_7 = FXGraphFactory.eINSTANCE.createStaticCallValueProperty();
                                JvmParameterizedTypeReference ttype = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
                                int idx = attributes.getLocalName(i).indexOf(".");
                                JvmType type = this.provider.findTypeByName(ReflectionHelper.getFqnType(attributes.getLocalName(i).substring(0, idx), this.simpleToFqn, this.globalImports));
                                ttype.setType(type);
                                pp_7.setType((JvmTypeReference)ttype);
                                String _localName = attributes.getLocalName(i);
                                int _indexOf_1 = attributes.getLocalName(i).indexOf(".");
                                int _plus_1 = _indexOf_1 + 1;
                                pp_7.setName(_localName.substring(_plus_1));
                                pp_7.setValue((ValueProperty)vp_8);
                                EList _staticCallProperties = e_2.getStaticCallProperties();
                                _staticCallProperties.add((Object)pp_7);
                            }
                        } else {
                            int idx_1 = attributes.getLocalName(i).indexOf(".");
                            JvmType type_1 = this.provider.findTypeByName(ReflectionHelper.getFqnType(attributes.getLocalName(i).substring(0, idx_1), this.simpleToFqn, this.globalImports));
                            ValueType vt_2 = ReflectionHelper.getStaticValueType(type_1, attributes.getLocalName(i).substring(idx_1 + 1));
                            SimpleValueProperty vp_9 = FXGraphFactory.eINSTANCE.createSimpleValueProperty();
                            boolean _equals_8 = Objects.equal((Object)((Object)vt_2), (Object)((Object)ValueType.BOOLEAN));
                            if (_equals_8) {
                                vp_9.setBooleanValue(attributes.getValue(i));
                            } else {
                                boolean _equals_9 = Objects.equal((Object)((Object)vt_2), (Object)((Object)ValueType.NUMBER));
                                if (_equals_9) {
                                    vp_9.setNumber(attributes.getValue(i));
                                } else {
                                    vp_9.setStringValue(attributes.getValue(i));
                                }
                            }
                            StaticCallValueProperty pp_8 = FXGraphFactory.eINSTANCE.createStaticCallValueProperty();
                            JvmParameterizedTypeReference ttype_1 = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
                            ttype_1.setType(type_1);
                            pp_8.setType((JvmTypeReference)ttype_1);
                            String _localName_1 = attributes.getLocalName(i);
                            int _indexOf_2 = attributes.getLocalName(i).indexOf(".");
                            int _plus_2 = _indexOf_2 + 1;
                            pp_8.setName(_localName_1.substring(_plus_2));
                            pp_8.setValue((ValueProperty)vp_9);
                            EList _staticCallProperties_1 = e_2.getStaticCallProperties();
                            _staticCallProperties_1.add((Object)pp_8);
                        }
                    }
                }
                ++i;
            }
            Element _rootNode = this.model.getComponentDef().getRootNode();
            _equals_1 = Objects.equal((Object)_rootNode, null);
            if (_equals_1) {
                ComponentDefinition _componentDef_1 = this.model.getComponentDef();
                _componentDef_1.setRootNode(e_2);
            }
            this.stack.push(e_2);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.valueOfType) {
            this.valueOfType = false;
            return;
        }
        Object o = this.stack.pop();
        if (!this.stack.isEmpty() && o instanceof Element) {
            Object _peek_2;
            Object _peek = this.stack.peek();
            if (_peek instanceof Element) {
                Object _peek_1 = this.stack.peek();
                EList _defaultChildren = ((Element)_peek_1).getDefaultChildren();
                _defaultChildren.add((Object)((Element)o));
            }
            if ((_peek_2 = this.stack.peek()) instanceof StaticCallValueProperty) {
                Object _peek_3 = this.stack.peek();
                ((StaticCallValueProperty)_peek_3).setValue((ValueProperty)((Element)o));
            } else {
                Object _peek_4 = this.stack.peek();
                if (_peek_4 instanceof Property) {
                    Object _peek_5 = this.stack.peek();
                    Property p = (Property)_peek_5;
                    ValueProperty _value = p.getValue();
                    boolean _equals = Objects.equal((Object)_value, null);
                    if (_equals) {
                        p.setValue((ValueProperty)((Element)o));
                    } else {
                        ValueProperty _value_1 = p.getValue();
                        EList _value_2 = ((ListValueProperty)_value_1).getValue();
                        _value_2.add((Object)((Element)o));
                    }
                }
            }
        }
    }
}

