/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.hover;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.css.cssDsl.ColorTok;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.FuncTok;
import org.eclipse.fx.ide.css.cssDsl.NumberTok;
import org.eclipse.fx.ide.css.extapi.CssExt;
import org.eclipse.fx.ide.css.util.Utils;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;

public class CssHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    private CssExt ext;
    @Inject(optional=true)
    @Named(value="org.eclipse.fx.ide.css.ui.styleSheetFileName")
    private String styleSheetFileName = "/CssDocsStyleSheet.css";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.XtextEditorHover.font")
    private String fontSymbolicName = "org.eclipse.jdt.ui.javadocfont";

    protected String getStyleSheet() {
        String css = this.loadStyleSheet();
        if (css != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData(this.fontSymbolicName)[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    protected String loadStyleSheet() {
        URL styleSheetURL = Platform.getBundle((String)"org.eclipse.fx.ide.css.ui").getEntry(this.styleSheetFileName);
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
            catch (IOException ex) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return "";
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    private String getColorHoverForFunction(FuncTok f) {
        if ("rgb".equals(f.getName().getName())) {
            String rgbHex = "#";
            int idx = 0;
            for (CssTok p : f.getParams()) {
                if (p instanceof NumberTok) {
                    String hex = Integer.toHexString((int)Math.round(((NumberTok)p).getVal()));
                    rgbHex = String.valueOf(rgbHex) + (hex.length() < 2 ? "0" + hex : hex);
                }
                if (idx == 3) break;
            }
            String rv = "<table><tr><td><div style='height: 20px; width: 20px;border:1;border-style:solid;background-color: " + rgbHex + "'></div></td><td>" + rgbHex + "</td></tr></table>";
            return rv;
        }
        return null;
    }

    protected String getHoverInfoAsHtml(EObject o) {
        if (o instanceof ColorTok) {
            ColorTok t = (ColorTok)o;
            String rv = "<table><tr><td><div style='height: 20px; width: 20px;border:1;border-style:solid;background-color: " + t.getValue() + "'></div></td><td>" + t.getValue() + "</td></tr></table>";
            return rv;
        }
        if (o instanceof FuncTok) {
            FuncTok f = (FuncTok)o;
            return this.getColorHoverForFunction(f);
        }
        if (o.eContainer() instanceof FuncTok) {
            return this.getColorHoverForFunction((FuncTok)o.eContainer());
        }
        return super.getHoverInfoAsHtml(o);
    }

    protected String getFirstLine(EObject o) {
        String firstLine = this.ext.getDocumentationHeader(Utils.getFile((Resource)o.eResource()), o, o);
        if (firstLine == null) {
            firstLine = super.getFirstLine(o);
        }
        return firstLine;
    }

    protected boolean hasHover(EObject o) {
        if (o.eResource() == null) {
            System.err.println("Cannot show doc for element without eResource: " + o);
            return false;
        }
        String firstLine = this.ext.getDocumentationHeader(Utils.getFile((Resource)o.eResource()), o, o);
        return firstLine != null;
    }
}

