/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.activator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.log.IEGFLogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class EGFAbstractUIPlugin
extends AbstractUIPlugin {
    private static final String ICONS_PATH = "$nl$/icons/full/";

    public static Display getWorkbenchDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public void log(IStatus status) {
        this.log(status, 0, true);
    }

    public void log(IStatus status, boolean appendLogger) {
        this.log(status, 0, appendLogger);
    }

    public void log(IStatus status, int nesting) {
        this.log(status, nesting, true);
    }

    public void log(IStatus status, int nesting, boolean appendLogger) {
        this.getLog().log(status);
        if (appendLogger) {
            for (IEGFLogger logger : EGFCommonPlugin.getEGFLoggers()) {
                logger.logStatus(status, nesting);
            }
        }
    }

    public void logInfo(String message) {
        this.logInfo(message, 0, true);
    }

    public void logInfo(String message, boolean appendLogger) {
        this.logInfo(message, 0, appendLogger);
    }

    public void logInfo(String message, int nesting) {
        this.logInfo(message, nesting, true);
    }

    public void logInfo(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, message, null), nesting, appendLogger);
    }

    public void logInfo(String message, Throwable t) {
        this.logInfo(message, t, 0, true);
    }

    public void logInfo(String message, Throwable t, boolean appendLogger) {
        this.logInfo(message, t, 0, appendLogger);
    }

    public void logInfo(String message, Throwable t, int nesting) {
        this.logInfo(message, t, nesting, true);
    }

    public void logInfo(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, message, t), nesting, appendLogger);
    }

    public void logInfo(Throwable t) {
        this.logInfo(t, 0, true);
    }

    public void logInfo(Throwable t, boolean appendLogger) {
        this.logInfo(t, 0, appendLogger);
    }

    public void logInfo(Throwable t, int nesting) {
        this.logInfo(t, nesting, true);
    }

    public void logInfo(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, t.getMessage(), t), nesting, appendLogger);
    }

    public void logError(String message) {
        this.logError(message, 0, true);
    }

    public void logError(String message, boolean appendLogger) {
        this.logError(message, 0, appendLogger);
    }

    public void logError(String message, int nesting) {
        this.logError(message, nesting, true);
    }

    public void logError(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, message, null), nesting, appendLogger);
    }

    public void logError(String message, Throwable t) {
        this.logError(message, t, 0, true);
    }

    public void logError(String message, Throwable t, boolean appendLogger) {
        this.logError(message, t, 0, appendLogger);
    }

    public void logError(String message, Throwable t, int nesting) {
        this.logError(message, t, nesting, true);
    }

    public void logError(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, message, t), nesting, appendLogger);
    }

    public void logError(Throwable t) {
        this.logError(t, 0, true);
    }

    public void logError(Throwable t, boolean appendLogger) {
        this.logError(t, 0, appendLogger);
    }

    public void logError(Throwable t, int nesting) {
        this.logError(t, nesting, true);
    }

    public void logError(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, t.getMessage(), t), nesting, appendLogger);
    }

    public void logWarning(String message) {
        this.logWarning(message, 0, true);
    }

    public void logWarning(String message, boolean appendLogger) {
        this.logWarning(message, 0, appendLogger);
    }

    public void logWarning(String message, int nesting) {
        this.logWarning(message, nesting, true);
    }

    public void logWarning(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, message, null), nesting, appendLogger);
    }

    public void logWarning(String message, Throwable t) {
        this.logWarning(message, t, 0, true);
    }

    public void logWarning(String message, Throwable t, boolean appendLogger) {
        this.logWarning(message, t, 0, appendLogger);
    }

    public void logWarning(String message, Throwable t, int nesting) {
        this.logWarning(message, t, nesting, true);
    }

    public void logWarning(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, message, t), nesting, appendLogger);
    }

    public void logWarning(Throwable t) {
        this.logWarning(t, 0, true);
    }

    public void logWarning(Throwable t, boolean appendLogger) {
        this.logWarning(t, 0, appendLogger);
    }

    public void logWarning(Throwable t, int nesting) {
        this.logWarning(t, nesting, true);
    }

    public void logWarning(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, t.getMessage(), t), nesting, appendLogger);
    }

    public IStatus newStatus(int severity, String message, Throwable exception) {
        return new Status(severity, this.getPluginID(), 0, message, exception);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = this.createImageDescriptor(key);
            imageRegistry.put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.createImageDescriptor(key);
            imageRegistry.put(key, imageDescriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }

    protected ImageDescriptor createImageDescriptor(String key) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getPluginID(), (String)(ICONS_PATH + key));
    }

    public String getPluginID() {
        return this.getBundle().getSymbolicName();
    }
}

