/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.ClassLoaderResource;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ClassLoadableResourceKeyPairProvider
extends AbstractResourceKeyPairProvider<String> {
    private ClassLoader classLoader;
    private Collection<String> resources;

    public ClassLoadableResourceKeyPairProvider() {
        this(Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl) {
        this(cl, Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(String res) {
        this(Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(res, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl, String res) {
        this(cl, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(res, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(Collection<String> resources) {
        this.classLoader = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader cl, Collection<String> resources) {
        this.classLoader = cl;
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        this.resources = resources == null ? Collections.emptyList() : resources;
    }

    public ClassLoader getResourceLoader() {
        return this.classLoader;
    }

    public void setResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return this.loadKeys(session, this.getResources());
    }

    @Override
    protected IoResource<?> getIoResource(SessionContext session, String resource) {
        return new ClassLoaderResource(this.resolveClassLoader(), resource);
    }

    protected ClassLoader resolveClassLoader() {
        ClassLoader cl = this.getResourceLoader();
        if (cl == null) {
            cl = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        }
        return cl;
    }
}

