/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ProjectSpaceBasedExportController;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;

public class ExportChangesController
extends ProjectSpaceBasedExportController {
    public ExportChangesController(ProjectSpace projectSpace) {
        super(projectSpace);
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore change package (" + ExportImportDataUnits.Change.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Change.getExtension(), "*.*"};
    }

    public String getLabel() {
        return "changes";
    }

    public String getFilename() {
        return "LocalChanges_" + this.getProjectSpace().getProjectName() + "@" + this.getProjectSpace().getBaseVersion().getIdentifier();
    }

    public String getParentFolderPropertyKey() {
        return null;
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        if (!FileUtil.getExtension((File)file).equals(ExportImportDataUnits.Change.getExtension())) {
            file = new File(file.getAbsoluteFile() + ExportImportDataUnits.Change.getExtension());
        }
        ResourceHelper.putElementIntoNewResourceWithProject(file.getAbsolutePath(), this.getProjectSpace().getLocalChangePackage(false), this.getProjectSpace().getProject());
    }

    public boolean isExport() {
        return true;
    }
}

