/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEEditorLaunchManager;
import org.eclipse.pde.internal.ui.editor.actions.ActionMenu;

public abstract class PDELauncherFormEditor
extends MultiSourceEditor {
    protected static final int RUN_LAUNCHER_INDEX = 0;
    protected static final int DEBUG_LAUNCHER_INDEX = 1;
    protected static final int PROFILE_LAUNCHER_INDEX = 2;
    ActionMenu[] fToolbarActions = new ActionMenu[3];
    LauncherAction[][] fActions = null;

    protected abstract ILauncherFormPageHelper getLauncherHelper();

    protected void contributeLaunchersToToolbar(IToolBarManager manager) {
        if (this.getLauncherHelper() != null) {
            List<String> recentLaunches = PDEEditorLaunchManager.getDefault().getRecentLaunches();
            LauncherAction[][] actions = this.getActions();
            if (actions[0].length > 0) {
                this.fToolbarActions[0] = new ActionMenu(actions[0]);
                this.fToolbarActions[0].updateActionOrder(recentLaunches);
                manager.add((IAction)this.fToolbarActions[0]);
            }
            if (actions[1].length > 0) {
                this.fToolbarActions[1] = new ActionMenu(actions[1]);
                this.fToolbarActions[1].updateActionOrder(recentLaunches);
                manager.add((IAction)this.fToolbarActions[1]);
            }
            if (actions[2].length > 0) {
                this.fToolbarActions[2] = new ActionMenu(actions[2]);
                this.fToolbarActions[2].updateActionOrder(recentLaunches);
                manager.add((IAction)this.fToolbarActions[2]);
            }
        }
    }

    private LauncherAction[][] getActions() {
        if (this.fActions == null) {
            this.fActions = new LauncherAction[3][];
            IConfigurationElement[][] elements = this.getLaunchers(this.getLauncherHelper().isOSGi());
            this.fActions[0] = this.getLauncherActions(elements[0], 0);
            this.fActions[1] = this.getLauncherActions(elements[1], 1);
            this.fActions[2] = this.getLauncherActions(elements[2], 2);
        }
        return this.fActions;
    }

    private LauncherAction[] getLauncherActions(IConfigurationElement[] elements, int toolbarIndex) {
        LauncherAction[] result = new LauncherAction[elements.length];
        int i = 0;
        while (i < elements.length) {
            LauncherAction thisAction;
            result[i] = thisAction = new LauncherAction(elements[i]){

                public void run() {
                    PDELauncherFormEditor.this.doSave(null);
                    String id = this.getConfigurationElement().getAttribute("id");
                    String mode = this.getConfigurationElement().getAttribute("mode");
                    PDELauncherFormEditor.this.launch(id, mode, PDELauncherFormEditor.this.getPreLaunchRunnable(), PDELauncherFormEditor.this.getLauncherHelper().getLaunchObject());
                    PDEEditorLaunchManager.getDefault().setRecentLaunch(this.getConfigurationElement().getAttribute("id"));
                    List<String> updatedActionOrder = PDEEditorLaunchManager.getDefault().getRecentLaunches();
                    ActionMenu[] actionMenuArray = PDELauncherFormEditor.this.fToolbarActions;
                    int n = PDELauncherFormEditor.this.fToolbarActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActionMenu action = actionMenuArray[n2];
                        if (action != null) {
                            action.updateActionOrder(updatedActionOrder);
                        }
                        ++n2;
                    }
                }
            };
            ++i;
        }
        return result;
    }

    protected Runnable getPreLaunchRunnable() {
        return () -> this.getLauncherHelper().preLaunch();
    }

    public void launch(String launcherID, String mode, Runnable preLaunch, Object launchObject) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (launcherID.equals(element.getAttribute("id"))) {
                try {
                    ILaunchShortcut shortcut = (ILaunchShortcut)element.createExecutableExtension("class");
                    preLaunch.run();
                    StructuredSelection selection = launchObject != null ? new StructuredSelection(launchObject) : StructuredSelection.EMPTY;
                    shortcut.launch((ISelection)selection, mode);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    protected IConfigurationElement[][] getLaunchers(boolean osgi) {
        String[] values22;
        IProject project;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.pde.ui.launchShortcuts");
        ArrayList<IConfigurationElement> runList = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> debugList = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> profileList = new ArrayList<IConfigurationElement>();
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        HashSet<String> specificIds = null;
        if (resource != null && (project = resource.getProject()) != null && (values22 = PDEProject.getLaunchShortcuts((IProject)project)) != null) {
            specificIds = new HashSet<String>();
            String[] stringArray = values22;
            int n = values22.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                specificIds.add(value);
                ++n2;
            }
        }
        IConfigurationElement[] iConfigurationElementArray = elements;
        int value = elements.length;
        int values22 = 0;
        while (values22 < value) {
            IConfigurationElement element = iConfigurationElementArray[values22];
            String mode = element.getAttribute("mode");
            String id = element.getAttribute("id");
            String projectSpecific = element.getAttribute("projectSpecific");
            if (mode != null && element.getAttribute("label") != null && id != null) {
                boolean include = false;
                if (specificIds != null) {
                    include = specificIds.contains(id);
                } else {
                    boolean bl = include = osgi == "true".equals(element.getAttribute("osgi")) && !"true".equals(projectSpecific);
                }
                if (include) {
                    if (mode.equals("run")) {
                        runList.add(element);
                    } else if (mode.equals("debug")) {
                        debugList.add(element);
                    } else if (mode.equals("profile")) {
                        profileList.add(element);
                    }
                }
            }
            ++values22;
        }
        IConfigurationElement[] runElements = runList.toArray(new IConfigurationElement[runList.size()]);
        IConfigurationElement[] debugElements = debugList.toArray(new IConfigurationElement[debugList.size()]);
        IConfigurationElement[] profileElements = profileList.toArray(new IConfigurationElement[profileList.size()]);
        return new IConfigurationElement[][]{runElements, debugElements, profileElements};
    }

    public static abstract class LauncherAction
    extends Action {
        private IConfigurationElement configElement;

        public LauncherAction(IConfigurationElement configurationElement) {
            this.configElement = configurationElement;
            String label = this.configElement.getAttribute("label");
            this.setText(label);
            this.setToolTipText(label);
            this.setImageDescriptor(this.getImageDescriptor(configurationElement.getAttribute("mode")));
        }

        public IConfigurationElement getConfigurationElement() {
            return this.configElement;
        }

        private ImageDescriptor getImageDescriptor(String mode) {
            if (mode == null) {
                return null;
            }
            if (mode.equals("run")) {
                return PDEPluginImages.DESC_RUN_EXC;
            }
            if (mode.equals("debug")) {
                return PDEPluginImages.DESC_DEBUG_EXC;
            }
            if (mode.equals("profile")) {
                return PDEPluginImages.DESC_PROFILE_EXC;
            }
            return null;
        }
    }
}

