/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.di.scope;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.glsp.server.di.DiagramType;
import org.eclipse.glsp.server.di.scope.DiagramGlobalScope;

public class DefaultDiagramGlobalScope
implements DiagramGlobalScope {
    private final Map<String, Map<Key<?>, Object>> diagramTypeStores = new ConcurrentHashMap();

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Optional<String> diagramType = DefaultDiagramGlobalScope.this.getDiagramType(unscoped);
                if (diagramType.isEmpty()) {
                    throw new IllegalArgumentException("Could not complete scoping operation. Diagram type could not be derived. Injector needs to be create with a 'GLSPDiagramModule'!");
                }
                return DefaultDiagramGlobalScope.this.getInstanceFromScope(diagramType.get(), key, unscoped);
            }
        };
    }

    protected synchronized <T> T getInstanceFromScope(String diagramType, Key<T> key, Provider<T> unscoped) {
        Map diagramStore = this.diagramTypeStores.computeIfAbsent(diagramType, k -> new HashMap());
        Object instance = diagramStore.computeIfAbsent(key, k -> unscoped.get());
        return (T)instance;
    }

    protected Optional<String> getDiagramType(Provider<?> unscoped) {
        return this.getInjector(unscoped).map(injector -> (String)injector.getInstance(Key.get(String.class, DiagramType.class)));
    }

    protected Optional<Injector> getInjector(Provider<?> unscoped) {
        try {
            Method getInjector = unscoped.getClass().getDeclaredMethod("getInjector", new Class[0]);
            getInjector.setAccessible(true);
            Injector injector = (Injector)getInjector.invoke(unscoped, new Object[0]);
            return Optional.of(injector);
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }

    public String toString() {
        return "DiagramGlobalScope";
    }
}

