/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.localfolder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.localfolder.FileBasedLocation;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class LocalFolder
extends FileBasedLocation {
    private Path rootLocation;
    private String lastIndexedRevision;
    private Set<File> previousFiles;
    private Map<String, byte[]> recordedDigests;
    private Function<File, Boolean> fileFilter;
    private DB db;

    public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        Path path;
        File fMapDB = File.createTempFile("localfolder", "mapdb");
        this.db = DBMaker.newFileDB((File)fMapDB).deleteFilesAfterClose().closeOnJvmShutdown().make();
        this.previousFiles = this.db.createHashSet("previousFiles").make();
        this.recordedDigests = this.db.createHashMap("recordedDigests").make();
        this.console = indexer.getConsole();
        try {
            path = Paths.get(new URI(vcsloc));
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            path = Paths.get(vcsloc, new String[0]);
        }
        File canonicalFile = path.toFile().getCanonicalFile();
        this.rootLocation = canonicalFile.toPath();
        String repositoryURI = this.rootLocation.toUri().toString();
        this.repositoryURL = canonicalFile.exists() ? repositoryURI : vcsloc;
    }

    @Override
    protected String getCurrentRevision(boolean alter) {
        try {
            FileDigestVisitor visitor = new FileDigestVisitor(alter);
            Files.walkFileTree(this.rootLocation, visitor);
            String ret = Base64.getEncoder().encodeToString(visitor.getTreeDigest());
            if (alter) {
                this.lastIndexedRevision = ret;
            }
            return String.valueOf(ret);
        }
        catch (Exception ex) {
            this.console.printerrln((Throwable)ex);
            return "0";
        }
    }

    public File importFile(String revision, String p, File temp) {
        try {
            String path = URLDecoder.decode(p.replace("+", "%2B"), "UTF-8");
            Path resolvedPath = this.rootLocation.resolve(path.startsWith("/") ? path.replaceFirst("/", "") : path);
            return resolvedPath.toFile();
        }
        catch (Exception e) {
            this.console.printerrln((Throwable)e);
            return null;
        }
    }

    public boolean isActive() {
        return this.rootLocation == null ? false : this.rootLocation.toFile().exists();
    }

    public void shutdown() {
        this.rootLocation = null;
        if (!this.db.isClosed()) {
            this.db.close();
        }
    }

    public String getHumanReadableName() {
        return "Local Folder Monitor";
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        ArrayList<VcsCommit> commits = new ArrayList<VcsCommit>();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(commits);
        delta.setManager((IVcsManager)this);
        String current = this.getCurrentRevision();
        HashSet<File> files = new HashSet<File>();
        this.addAllFiles(this.rootLocation.toFile(), files);
        this.previousFiles.removeAll(files);
        for (File f : this.previousFiles) {
            VcsCommit commit = new VcsCommit();
            commit.setAuthor("i am a local folder driver - no authors recorded");
            commit.setJavaDate(new Date());
            commit.setMessage("i am a local folder driver - no messages recorded");
            commit.setRevision(current);
            commits.add(commit);
            VcsCommitItem c = new VcsCommitItem();
            c.setChangeType(VcsChangeType.DELETED);
            c.setCommit(commit);
            Path path = f.toPath();
            String relativepath = this.makeRelative(this.repositoryURL, f.toPath().toUri().toString());
            c.setPath(relativepath.startsWith("/") ? relativepath : "/" + relativepath);
            commit.getItems().add(c);
            this.recordedDigests.remove(path.toString());
        }
        this.previousFiles.clear();
        if (files != null && files.size() > 0) {
            for (File f : files) {
                this.previousFiles.add(f);
                Path filePath = f.toPath();
                byte[] fileDigest = this.digestFile(f);
                byte[] recordedDigest = this.recordedDigests.get(filePath.toString());
                if (recordedDigest != null && Arrays.equals(recordedDigest, fileDigest) && String.valueOf(this.lastIndexedRevision).equals(startRevision)) continue;
                this.recordedDigests.put(filePath.toString(), fileDigest);
                VcsCommit commit = new VcsCommit();
                commit.setAuthor("i am a local folder driver - no authors recorded");
                commit.setJavaDate(new Date());
                commit.setMessage("i am a local folder driver - no messages recorded");
                commit.setRevision(current);
                commits.add(commit);
                VcsCommitItem c = new VcsCommitItem();
                c.setChangeType(VcsChangeType.UPDATED);
                c.setCommit(commit);
                String relativepath = this.makeRelative(this.repositoryURL, f.toPath().toUri().toString());
                c.setPath(relativepath.startsWith("/") ? relativepath : "/" + relativepath);
                commit.getItems().add(c);
            }
        }
        this.lastIndexedRevision = current;
        return delta;
    }

    public Function<File, Boolean> getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(Function<File, Boolean> fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected void addAllFiles(File dir, Set<File> ret) {
        File[] files = dir.listFiles();
        if (files == null) {
            this.console.printerrln("Could not list the entries of " + dir);
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isFileInteresting(file)) {
                if (!file.isDirectory()) {
                    ret.add(file);
                } else {
                    this.addAllFiles(file, ret);
                }
            }
            ++n2;
        }
    }

    private boolean isFileInteresting(File f) {
        return this.fileFilter == null || this.fileFilter.apply(f) != false;
    }

    public String getDefaultLocation() {
        return "file://path/to/folder";
    }

    private final class FileDigestVisitor
    implements FileVisitor<Path> {
        private boolean alter;
        private MessageDigest treeDigest;

        public FileDigestVisitor(boolean alter) throws NoSuchAlgorithmException {
            this.alter = alter;
            this.treeDigest = MessageDigest.getInstance("SHA");
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (LocalFolder.this.isFileInteresting(dir.toFile())) {
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            File f = file.toFile();
            if (LocalFolder.this.isFileInteresting(f)) {
                byte[] fileDigest = LocalFolder.this.digestFile(f);
                if (this.alter) {
                    LocalFolder.this.recordedDigests.put(file.toString(), fileDigest);
                }
                this.treeDigest.update(f.getPath().getBytes());
                this.treeDigest.update(fileDigest);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public byte[] getTreeDigest() {
            return this.treeDigest.digest();
        }
    }
}

