/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.tests.timeaware;

import java.io.File;
import java.util.Collections;
import org.eclipse.hawk.backend.tests.LogbackOnlyErrorsRule;
import org.eclipse.hawk.backend.tests.RedirectSystemErrorRule;
import org.eclipse.hawk.backend.tests.TemporaryDatabaseTest;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.greycat.tests.LevelDBGreycatDatabaseFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TimeAwareGreycatHeavyEdgeTests
extends TemporaryDatabaseTest {
    private ITimeAwareGraphDatabase taDB;
    @Rule
    public RedirectSystemErrorRule errRule = new RedirectSystemErrorRule();
    @Rule
    public LogbackOnlyErrorsRule logRule = new LogbackOnlyErrorsRule();

    public TimeAwareGreycatHeavyEdgeTests(File baseDir, IGraphDatabaseFactory dbf) {
        super(dbf);
    }

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        Object[] objectArray = new Object[2];
        objectArray[1] = new LevelDBGreycatDatabaseFactory();
        return Collections.singletonList(objectArray);
    }

    public void setup() throws Exception {
        super.setup();
        this.taDB = (ITimeAwareGraphDatabase)this.db;
    }

    @Test
    public void createDeleteHeavyEdgeBeginningOfTime() throws Exception {
        this.taDB.setTime(0L);
        this.createDeleteHeavyEdge();
    }

    @Test
    public void createDeleteHeavyEdgeNonZeroTime() throws Exception {
        this.taDB.setTime(1L);
        this.createDeleteHeavyEdge();
    }

    private void createDeleteHeavyEdge() throws Exception {
        Object heavyEdgeId;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(null, "example");
                IGraphNode n2 = this.db.createNode(null, "example");
                IGraphEdge e = this.db.createRelationship(n1, n2, "example", Collections.singletonMap("key", "value"));
                heavyEdgeId = e.getId();
                e.delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                ITimeAwareGraphNode backingNode = this.taDB.getNodeById(heavyEdgeId);
                Assert.assertFalse((boolean)backingNode.isAlive());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

