/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class CooperativeHandler {
    private static final int OFFLOAD = 1;
    private static final int AGAIN = 2;
    private static final int BEGIN = 4;
    private static final int STOP = 8;
    private static final int END = 16;
    private final AtomicInteger state = new AtomicInteger(16);
    private final Consumer<Runnable> begin;

    public CooperativeHandler(Runnable runnable) {
        this(CooperativeHandler.asyncOf(runnable));
    }

    public CooperativeHandler(Consumer<Runnable> consumer) {
        this.begin = Objects.requireNonNull(consumer);
    }

    public void handle() {
        block3: {
            int n;
            block4: {
                while (true) {
                    if ((n = this.state.get()) == 16) {
                        if (!this.state.compareAndSet(16, 4)) continue;
                        break block3;
                    }
                    if ((n & 4) == 0) break block4;
                    if (this.state.compareAndSet(n, 2 | n & 1)) break;
                }
                return;
            }
            if ((n & 2) != 0 || n == 8) {
                return;
            }
            throw new InternalError(String.valueOf(n));
        }
        this.begin.accept(this::tryEnd);
    }

    private void tryEnd() {
        while (true) {
            int n;
            if (((n = this.state.get()) & 1) != 0) {
                if (!this.state.compareAndSet(n, n & 0xFFFFFFFE)) continue;
                return;
            }
            while (true) {
                if (n == 4) {
                    if (this.state.compareAndSet(4, 16)) {
                        return;
                    }
                } else if (n == 2) {
                    if (this.state.compareAndSet(2, 5)) {
                        break;
                    }
                } else {
                    if (n == 8) {
                        return;
                    }
                    throw new InternalError(String.valueOf(n));
                }
                n = this.state.get();
            }
            this.begin.accept(this::tryEnd);
        }
    }

    public boolean isStopped() {
        return this.state.get() == 8;
    }

    public void stop() {
        this.state.set(8);
    }

    private static Consumer<Runnable> asyncOf(Runnable runnable) {
        Objects.requireNonNull(runnable);
        return runnable2 -> {
            runnable.run();
            runnable2.run();
        };
    }
}

