/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONBuffer
implements Serializable {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final long serialVersionUID = 5946166401452532693L;
    private final boolean multiLine;
    private boolean needComma = false;
    private ByteStringBuffer buffer;
    private final int maxBufferSize;
    private final LinkedList<String> indents;

    public JSONBuffer() {
        this(0x100000);
    }

    public JSONBuffer(int maxBufferSize) {
        this(null, maxBufferSize, false);
    }

    public JSONBuffer(ByteStringBuffer buffer, int maxBufferSize, boolean multiLine) {
        this.multiLine = multiLine;
        this.maxBufferSize = maxBufferSize;
        this.indents = new LinkedList();
        this.needComma = false;
        this.buffer = buffer == null ? new ByteStringBuffer() : buffer;
    }

    public void clear() {
        this.buffer.clear();
        if (this.maxBufferSize > 0 && this.buffer.capacity() > this.maxBufferSize) {
            this.buffer.setCapacity(this.maxBufferSize);
        }
        this.needComma = false;
        this.indents.clear();
    }

    public void setBuffer(ByteStringBuffer buffer) {
        this.buffer = buffer == null ? new ByteStringBuffer() : buffer;
        this.needComma = false;
        this.indents.clear();
    }

    public int length() {
        return this.buffer.length();
    }

    public void beginObject() {
        this.addComma();
        this.buffer.append("{ ");
        this.needComma = false;
        this.addIndent(2);
    }

    public void beginObject(String fieldName) {
        this.addComma();
        int startPos = this.buffer.length();
        JSONString.encodeString(fieldName, this.buffer);
        int fieldNameLength = this.buffer.length() - startPos;
        this.buffer.append(":{ ");
        this.needComma = false;
        this.addIndent(fieldNameLength + 3);
    }

    public void endObject() {
        if (this.needComma) {
            this.buffer.append(' ');
        }
        this.buffer.append('}');
        this.needComma = true;
        this.removeIndent();
    }

    public void beginArray() {
        this.addComma();
        this.buffer.append("[ ");
        this.needComma = false;
        this.addIndent(2);
    }

    public void beginArray(String fieldName) {
        this.addComma();
        int startPos = this.buffer.length();
        JSONString.encodeString(fieldName, this.buffer);
        int fieldNameLength = this.buffer.length() - startPos;
        this.buffer.append(":[ ");
        this.needComma = false;
        this.addIndent(fieldNameLength + 3);
    }

    public void endArray() {
        if (this.needComma) {
            this.buffer.append(' ');
        }
        this.buffer.append(']');
        this.needComma = true;
        this.removeIndent();
    }

    public void appendBoolean(boolean value) {
        this.addComma();
        if (value) {
            this.buffer.append("true");
        } else {
            this.buffer.append("false");
        }
        this.needComma = true;
    }

    public void appendBoolean(String fieldName, boolean value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        if (value) {
            this.buffer.append(":true");
        } else {
            this.buffer.append(":false");
        }
        this.needComma = true;
    }

    public void appendNull() {
        this.addComma();
        this.buffer.append("null");
        this.needComma = true;
    }

    public void appendNull(String fieldName) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(":null");
        this.needComma = true;
    }

    public void appendNumber(BigDecimal value) {
        this.addComma();
        this.buffer.append(value.toPlainString());
        this.needComma = true;
    }

    public void appendNumber(int value) {
        this.addComma();
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendNumber(long value) {
        this.addComma();
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendNumber(String value) {
        this.addComma();
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendNumber(String fieldName, BigDecimal value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(':');
        this.buffer.append(value.toPlainString());
        this.needComma = true;
    }

    public void appendNumber(String fieldName, int value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(':');
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendNumber(String fieldName, long value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(':');
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendNumber(String fieldName, String value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(':');
        this.buffer.append(value);
        this.needComma = true;
    }

    public void appendString(String value) {
        this.addComma();
        JSONString.encodeString(value, this.buffer);
        this.needComma = true;
    }

    public void appendString(String fieldName, String value) {
        this.addComma();
        JSONString.encodeString(fieldName, this.buffer);
        this.buffer.append(':');
        JSONString.encodeString(value, this.buffer);
        this.needComma = true;
    }

    public void appendValue(JSONValue value) {
        value.appendToJSONBuffer(this);
    }

    public void appendValue(String fieldName, JSONValue value) {
        value.appendToJSONBuffer(fieldName, this);
    }

    public ByteStringBuffer getBuffer() {
        return this.buffer;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.buffer.write(outputStream);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject(this.buffer.toString());
    }

    private void addComma() {
        if (this.needComma) {
            this.buffer.append(',');
            if (this.multiLine) {
                this.buffer.append(StaticUtils.EOL_BYTES);
                this.buffer.append(this.indents.getLast());
            } else {
                this.buffer.append(' ');
            }
        }
    }

    private void addIndent(int size) {
        if (this.multiLine) {
            char[] spaces = new char[size];
            Arrays.fill(spaces, ' ');
            String indentStr = new String(spaces);
            if (this.indents.isEmpty()) {
                this.indents.add(indentStr);
            } else {
                this.indents.add(this.indents.getLast() + indentStr);
            }
        }
    }

    private void removeIndent() {
        if (this.multiLine && !this.indents.isEmpty()) {
            this.indents.removeLast();
        }
    }
}

