/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext;

import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.TemplateFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Provider
@Priority(value=100)
@PreMatching
public class RequestFilter
extends TemplateFilter {
    public static final String PRINCIPAL = "PrincipalName";
    public static final String SETENTITYSTREAMENTITY = "SetEntityStreamEntity";
    public static final String URI = "http://xx.yy:888/base/resource/sub";

    public void abortWith() {
        this.abortWithEntity(null);
    }

    public void getAcceptableLanguages() {
        List langs = this.requestContext.getAcceptableLanguages();
        this.abortWithEntity(RequestFilter.collectionToString(langs));
    }

    public void getAcceptableLanguagesIsReadOnly() {
        List langs = this.requestContext.getAcceptableLanguages();
        if (this.assertTrue(!langs.contains(Locale.CANADA_FRENCH), Locale.CANADA_FRENCH, "already included")) {
            return;
        }
        try {
            langs.add(Locale.CANADA_FRENCH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        langs = this.requestContext.getAcceptableLanguages();
        if (this.assertTrue(!langs.contains(Locale.CANADA_FRENCH), Locale.CANADA_FRENCH, "included, the list is not read-only")) {
            return;
        }
        this.abortWithEntity(RequestFilter.collectionToString(langs));
    }

    public void getAcceptableMediaTypes() {
        List types = this.requestContext.getAcceptableMediaTypes();
        this.abortWithEntity(RequestFilter.collectionToString(types));
    }

    public void getAcceptableMediaTypesIsReadOnly() {
        List types = this.requestContext.getAcceptableMediaTypes();
        if (this.assertTrue(!types.contains(MediaType.APPLICATION_JSON_TYPE), "application/json", "already included")) {
            return;
        }
        try {
            types.add(MediaType.APPLICATION_JSON_TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        types = this.requestContext.getAcceptableMediaTypes();
        if (this.assertTrue(!types.contains(MediaType.APPLICATION_JSON_TYPE), "application/json", "included, the list is not read-only")) {
            return;
        }
        this.abortWithEntity(RequestFilter.collectionToString(types));
    }

    public void getCookies() {
        Map cookies = this.requestContext.getCookies();
        Collection values = cookies.values();
        this.abortWithEntity(RequestFilter.collectionToString(values));
    }

    public void getCookiesIsReadOnly() {
        Map cookies = this.requestContext.getCookies();
        int length = cookies.size();
        try {
            cookies.put("key", new Cookie("coo", "kie"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cookies = this.requestContext.getCookies();
        if (this.assertTrue(cookies.size() == length, "Cookie was added present")) {
            return;
        }
        this.abortWithEntity("#getCookies is read-only as expected");
    }

    public void getDate() {
        Date date = this.requestContext.getDate();
        this.abortWithEntity(String.valueOf(date == null ? "NULL" : Long.valueOf(date.getTime())));
    }

    public void getEntityStream() throws IOException {
        InputStream stream = this.requestContext.getEntityStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(isr);
        String entity = br.readLine();
        br.close();
        this.abortWithEntity(entity);
    }

    public void containsHeaderString() {
        StringBuffer sb = new StringBuffer();
        sb.append("containsHeaderString= ");
        try {
            this.assertTrue(this.requestContext.containsHeaderString("accept", "text/html"::equals), new Object[0]);
            sb.append("Test1: accept contains text/html; ");
            this.assertTrue(this.requestContext.containsHeaderString("Accept", ",", "Text/html;Level=1"::equalsIgnoreCase), new Object[0]);
            sb.append("Test2: accept contains text/html;level=1; ");
            this.assertTrue(!this.requestContext.containsHeaderString("Accept", ";", "text/html;level=1"::equals), new Object[0]);
            sb.append("Test3: Incorrect separator character fails as expected; ");
            this.assertTrue(!this.requestContext.containsHeaderString("header3", ";;", "value3"::equals), new Object[0]);
            sb.append("Test4: White space not trimmed from value as expected; ");
            this.assertTrue(this.requestContext.containsHeaderString("HEADER3", ";;", "value2"::equalsIgnoreCase), new Object[0]);
            sb.append("Test5: White space trimmed around value as expected; ");
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown in containsHeaderString: " + ex.getMessage());
            ex.printStackTrace();
        }
        this.abortWithEntity(sb.toString());
    }

    public void getHeaders() {
        MultivaluedMap headers = this.requestContext.getHeaders();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry set : headers.entrySet()) {
            String first = (String)headers.getFirst((Object)((String)set.getKey()));
            sb.append((String)set.getKey()).append(":").append(first).append(";");
        }
        this.abortWithEntity(sb.toString());
    }

    public void getHeadersIsMutable() {
        String key = "KEY";
        MultivaluedMap headers = this.requestContext.getHeaders();
        if (this.assertTrue(!headers.containsKey((Object)key), "Key", key, "is already present")) {
            return;
        }
        headers.add((Object)key, (Object)"VALUE");
        this.assertTrue(headers.containsKey((Object)key), "Key", key, "not found");
    }

    public void getHeaderString2() {
        String string = this.requestContext.getHeaderString("OPERATION");
        this.abortWithEntity(string);
    }

    public void getLanguage() {
        Locale lang = this.requestContext.getLanguage();
        String entity = lang == null ? "NULL" : RequestFilter.collectionToString(Collections.singleton(lang));
        this.abortWithEntity(entity);
    }

    public void getLength() {
        int len = this.requestContext.getLength();
        this.abortWithEntity(String.valueOf(len));
    }

    public void getMediaType() {
        MediaType media = this.requestContext.getMediaType();
        this.abortWithEntity(media == null ? "NULL" : media.toString());
    }

    public void getMethod() {
        String method = this.requestContext.getMethod();
        this.abortWithEntity(method);
    }

    public void getProperty() {
        Object o = this.requestContext.getProperty("getSetProperty");
        this.abortWithEntity(o == null ? "NULL" : o.toString());
    }

    public void getPropertyNames() {
        int length = this.requestContext.getPropertyNames().size();
        for (int i = 0; i != 5; ++i) {
            this.requestContext.setProperty("getSetProperty" + i, (Object)"getSetProperty");
        }
        Collection names = this.requestContext.getPropertyNames();
        this.assertTrue(names.size() == 5 + length, "#getPropertyNames has unexpected number of elements", names.size(), "before any addition it was", length);
    }

    public void getPropertyNamesIsReadOnly() {
        Collection names = this.requestContext.getPropertyNames();
        int length = names.size();
        for (int i = 0; i != 5; ++i) {
            try {
                names.add("getSetProperty" + i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        names = this.requestContext.getPropertyNames();
        if (this.assertTrue(names.size() == length, "#getPropertyNames has unexpected elements", names)) {
            return;
        }
        this.abortWithEntity("0");
    }

    public void getRequest() {
        Request request = this.requestContext.getRequest();
        String method = request.getMethod();
        this.abortWithEntity(method);
    }

    public void getSecurityContext() {
        SecurityContext secCtx = this.requestContext.getSecurityContext();
        Principal principal = secCtx.getUserPrincipal();
        if (this.assertTrue(principal == null, "principal is not null")) {
            return;
        }
        this.abortWithEntity("NULL");
    }

    public void getUriInfo() {
        UriInfo info = this.requestContext.getUriInfo();
        this.abortWithEntity(info.getAbsolutePath().toASCIIString());
    }

    public void hasEntity() {
        boolean has = this.requestContext.hasEntity();
        this.abortWithEntity(String.valueOf(has).toLowerCase());
    }

    public void removeProperty() {
        this.setProperty();
        this.requestContext.removeProperty("getSetProperty");
        this.getProperty();
    }

    public void setEntityStream() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(SETENTITYSTREAMENTITY.getBytes());
        this.requestContext.setEntityStream((InputStream)stream);
        this.getEntityStream();
    }

    public void setMethod() {
        this.requestContext.setMethod("OPTIONS");
    }

    public void setProperty() {
        this.requestContext.setProperty("getSetProperty", (Object)"getSetPropertygetSetProperty");
        this.assertTrue(this.requestContext.getProperty("getSetProperty") != null, "property", "getSetProperty", "not found");
    }

    public void setPropertyNull() {
        this.setProperty();
        this.requestContext.setProperty("getSetProperty", null);
        this.getProperty();
    }

    public void setPropertyContext() {
        this.requestContext.setProperty("getSetProperty", (Object)"getSetProperty");
    }

    public void setRequestUri1() throws IOException {
        URI uri;
        try {
            UriInfo info = this.requestContext.getUriInfo();
            String path = info.getAbsolutePath() + "uri";
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.requestContext.setRequestUri(uri);
    }

    public void setRequestUri2() throws IOException {
        URI suffix;
        URI base;
        try {
            base = new URI("http://localhost:888/otherbase");
            suffix = new URI(URI);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.requestContext.setRequestUri(base, suffix);
        this.getUriInfo();
    }

    public void setSecurityContext() throws IOException {
        SecurityContextImpl secCtx = new SecurityContextImpl(PRINCIPAL, false, false, null);
        this.requestContext.setSecurityContext((SecurityContext)secCtx);
    }
}

