/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.response;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

@Provider
public class DateReaderWriter
implements MessageBodyReader<Date>,
MessageBodyWriter<Date> {
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_CONSUMES = 4;
    public static final int ANNOTATION_PROVIDER = 8;
    public static final int ANNOTATION_UNKNOWN = 128;
    private AtomicInteger atom;

    public DateReaderWriter(AtomicInteger atom) {
        this.atom = atom;
    }

    public long getSize(Date arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return String.valueOf(Long.MAX_VALUE).length();
    }

    public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return arg0 == Date.class;
    }

    public void writeTo(Date date, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream stream) throws IOException, WebApplicationException {
        this.parseAnnotations(arg3);
        stream.write(String.valueOf(date.getTime()).getBytes());
    }

    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return this.isWriteable(arg0, arg1, arg2, arg3);
    }

    public Date readFrom(Class<Date> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
        this.parseAnnotations(arg2);
        InputStreamReader reader = new InputStreamReader(arg5);
        BufferedReader br = new BufferedReader(reader);
        long date = Long.parseLong(br.readLine());
        return new Date(date);
    }

    protected void parseAnnotations(Annotation[] annotations) {
        int value = 0;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() == Consumes.class) {
                    value |= 4;
                    continue;
                }
                if (annotation.annotationType() == Provider.class) {
                    value |= 8;
                    continue;
                }
                value |= 0x80;
            }
        }
        this.atom.set(value);
    }
}

