/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.beanparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import jakarta.ws.rs.core.MediaType;
import org.junit.jupiter.api.Assertions;

public abstract class BeanParamCommonClient
extends JaxrsParamClient {
    private static final long serialVersionUID = 201L;
    protected String fieldBeanParam;
    protected int exceptionInEntity = 0;

    private void setFieldOrBean(String prefix) {
        this.fieldBeanParam = prefix.contains("Field") ? "Field" : "Param";
    }

    @Override
    protected void fieldOrParamEntityName(Class<?> entityClazz, String nonDefaultValue, String ... prefix) throws JAXRSCommonClient.Fault {
        this.setFieldOrBean(prefix[0]);
        if (prefix[0].contains("Field")) {
            prefix[0] = "";
        }
        super.fieldOrParamEntityName(entityClazz, nonDefaultValue, prefix);
    }

    @Override
    protected void fieldOrParamThrowingWebApplicationExceptionTest(String prefix) throws JAXRSCommonClient.Fault {
        this.setFieldOrBean(prefix);
        ++this.exceptionInEntity;
        super.fieldOrParamThrowingWebApplicationExceptionTest("");
    }

    @Override
    protected void fieldOrParamThrowingIllegalArgumentExceptionTest(String prefix) throws JAXRSCommonClient.Fault {
        this.setFieldOrBean(prefix);
        ++this.exceptionInEntity;
        super.fieldOrParamThrowingIllegalArgumentExceptionTest("");
    }

    @Override
    protected void fieldOrParamEncodedTest(String prefix) throws JAXRSCommonClient.Fault {
        this.setFieldOrBean(prefix);
        StringBuilder request = new StringBuilder();
        request.append(ParamEntityWithValueOf.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request.toString() + "=%21"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.fieldBeanParam, request.toString(), "=!");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Inner", this.fieldBeanParam, request.toString(), "=!");
        this.invoke();
        request = new StringBuilder();
        request.append(ParamEntityWithFromString.class.getSimpleName());
        request.append("=%21");
        this.paramEntity(request.toString());
    }

    @Override
    protected void paramEntity(String request) throws JAXRSCommonClient.Fault {
        if (this.searchEqualsEncoded) {
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, this.fieldBeanParam, request.replace("=", "%3d"));
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "Inner", this.fieldBeanParam, request.replace("=", "%3d"));
        } else {
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.fieldBeanParam, request);
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Inner", this.fieldBeanParam, request);
        }
        this.buildRequestAndInvoke(request);
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldBeanParam).append(param).append("=");
        sb.append("DefaultParamValue");
        sb.append("|").append("Inner").append(this.fieldBeanParam);
        sb.append(param).append("=");
        sb.append("DefaultParamValue");
        return sb.toString();
    }

    @Override
    protected void invoke() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, BeanParamCommonClient.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, BeanParamCommonClient.buildAccept(MediaType.WILDCARD_TYPE));
        super.invoke();
    }

    @Override
    protected void buildRequestAndInvoke(String request) throws JAXRSCommonClient.Fault {
        String req = this.exceptionInEntity == 0 ? this.buildRequest(request) : this.buildRequestForException(request, this.exceptionInEntity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, req);
        this.invoke();
    }

    protected String buildRequestForException(String param, int entity) throws JAXRSCommonClient.Fault {
        return this.buildRequest(param);
    }

    protected void createAndCheckCookie(String param, String uri) throws JAXRSCommonClient.Fault {
        String requestForCookie = param + ";Inner" + param;
        this.setProperty(JAXRSCommonClient.Property.CONTENT, requestForCookie);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, uri));
        this.setProperty(JAXRSCommonClient.Property.SAVE_STATE, "true");
        this.invoke();
        this.checkCookie(param);
        this.setProperty(JAXRSCommonClient.Property.USE_SAVED_STATE, "true");
    }

    protected void checkCookie(String cookie) throws JAXRSCommonClient.Fault {
        Object[] headers;
        boolean found = false;
        String lowCookie = BeanParamCommonClient.stripQuotesSpacesAndLowerCase(cookie);
        for (String string : headers = this.getResponseHeaders()) {
            String header = BeanParamCommonClient.stripQuotesSpacesAndLowerCase(string);
            if (!header.startsWith("set-cookie") || !header.contains(lowCookie)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)("Could not find cookie" + cookie + "in response headers:" + JaxrsUtil.iterableToString(";", headers)));
        BeanParamCommonClient.logMsg("Found cookie", cookie, "as expected");
    }

    protected static String stripQuotesSpacesAndLowerCase(String cookie) {
        return cookie.toLowerCase().replace("\"", "").replace("'", "").replace(" ", "");
    }
}

