/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs31.spec.extensions;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.jaxrs31.spec.extensions.DynamicFeatureResource;
import ee.jakarta.tck.ws.rs.jaxrs31.spec.extensions.TSAppConfig;
import ee.jakarta.tck.ws.rs.jaxrs31.spec.extensions.TckDynamicFeature;
import ee.jakarta.tck.ws.rs.jaxrs31.spec.extensions.TckFeature;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 31L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_jaxrs31_spec_jdkservices_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        StringAsset dynamicFeatureServiceFile = new StringAsset(TckDynamicFeature.class.getName());
        StringAsset featureServiceFile = new StringAsset(TckFeature.class.getName());
        String prefix = "classes/META-INF/services/";
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs31_spec_jdkservices_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, DynamicFeatureResource.class, TckFeature.class, TckFeature.TckFeatureFilter.class, TckDynamicFeature.class, TckDynamicFeature.TckDynamicFeatureFilter.class});
        archive.addAsWebInfResource((Asset)dynamicFeatureServiceFile, prefix + DynamicFeature.class.getName());
        archive.addAsWebInfResource((Asset)featureServiceFile, prefix + Feature.class.getName());
        return archive;
    }

    @Test
    public void featureIsRegisteredTest() throws JAXRSCommonClient.Fault {
        try (Response response = ClientBuilder.newClient().target(this.getAbsoluteUrl("staticFeature")).request().get();){
            JAXRSClientIT.assertEquals(200, response.getStatus(), new Object[0]);
            JAXRSClientIT.assertEquals(TckFeature.class.getName(), (String)response.readEntity(String.class), new Object[0]);
        }
        catch (Exception e) {
            JAXRSClientIT.fault(e);
        }
    }

    @Test
    public void dynamicFeatureIsRegisteredTest() throws JAXRSCommonClient.Fault {
        try (Response response = ClientBuilder.newClient().target(this.getAbsoluteUrl("dynamicFeature")).request().get();){
            JAXRSClientIT.assertEquals(200, response.getStatus(), new Object[0]);
            JAXRSClientIT.assertEquals(TckDynamicFeature.class.getName(), (String)response.readEntity(String.class), new Object[0]);
        }
        catch (Exception e) {
            JAXRSClientIT.fault(e);
        }
    }
}

