/*
 * Copyright (c) 2012, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package ee.jakarta.tck.ws.rs.spec.provider.reader;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;

@Path("resource")
public class Resource {
  @Context
  HttpHeaders headers;

  @Path("plain")
  @POST
  public String plain(EntityForReader efr) {
    AbstractReader.resetSet();
    return efr.toString() + ";"
        + headers.getHeaderString(HttpHeaders.CONTENT_TYPE);
  }

  @Path("appjava")
  @POST
  public Response enableAppJava(boolean enable) {
    AppJavaReader.setWritable(enable);
    AbstractReader.resetSet();
    return Response.ok().build();
  }
}
