/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.minexclusive.minexclusive_4;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive4_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive4_GetSetCTTests test = new minExclusive4_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "minExclusive-4-1.xml", "minExclusive-4-2.xml", "minExclusive-4-3.xml",
            "minExclusive-4-4.xml", "minExclusive-4-5.xml"
        };
        Long[] expectedValues = {new Long("-990226385260806197"), new Long("-766146509779750255"), 
                                       new Long("-116372577185606329"), new Long("-407345381971923453"), 
                                       new Long("0")};
        Long[] anExpectedValues = {new Long("-990226385260806197"), new Long("-76614650"), 
                                         new Long("0"), new Long("-1"), new Long("-990226385260806197")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Long> elemObj = (JAXBElement<Long>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        Long[] setValues = {new Long("-990226385260806197"), new Long("-766146509779750255"), 
                                       new Long("-116372577185606329"), new Long("-407345381971923453"), 
                                       new Long("0")};
        Long[] anSetValues = {new Long("-990226385260806197"), new Long("-76614650"), 
                                         new Long("0"), new Long("-1"), new Long("-990226385260806197")};

        JAXBElement<Long> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Long>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinExclusive4(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<Long>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<Long>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

