/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.correction.AbstractQuickFixTest;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.junit.Before;
import org.junit.Test;

public class SerialVersionQuickFixTest
extends AbstractQuickFixTest {
    private IJavaProject fJProject1;
    private IPackageFragmentRoot fSourceFolder;

    @Before
    public void setup() throws Exception {
        this.fJProject1 = this.newEmptyProject();
        Hashtable<String, String> options = TestOptions.getDefaultOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "error");
        this.fJProject1.setOptions(options);
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src"));
    }

    @Test
    public void testLocalClass() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test3", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test5 {\n");
        buf.append("    public void test() {\n");
        buf.append("        class X implements Serializable, Cloneable, Runnable {\n");
        buf.append("            private static final int x= 1;\n");
        buf.append("            private Object y;\n");
        buf.append("            public X() {\n");
        buf.append("            }\n");
        buf.append("            public void run() {}\n");
        buf.append("            public synchronized strictfp void bar() {}\n");
        buf.append("            public String bar(int x, int y) { return null; };\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test5.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test5 {\n");
        buf.append("    public void test() {\n");
        buf.append("        class X implements Serializable, Cloneable, Runnable {\n");
        buf.append("            private static final long serialVersionUID = 1L;\n");
        buf.append("            private static final int x= 1;\n");
        buf.append("            private Object y;\n");
        buf.append("            public X() {\n");
        buf.append("            }\n");
        buf.append("            public void run() {}\n");
        buf.append("            public synchronized strictfp void bar() {}\n");
        buf.append("            public String bar(int x, int y) { return null; };\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test5 {\n");
        buf.append("    public void test() {\n");
        buf.append("        class X implements Serializable, Cloneable, Runnable {\n");
        buf.append("            private static final long serialVersionUID = -4564939359985118485L;\n");
        buf.append("            private static final int x= 1;\n");
        buf.append("            private Object y;\n");
        buf.append("            public X() {\n");
        buf.append("            }\n");
        buf.append("            public void run() {}\n");
        buf.append("            public synchronized strictfp void bar() {}\n");
        buf.append("            public String bar(int x, int y) { return null; };\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testAnonymousClass() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test3", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test3 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    public void test() {\n");
        buf.append("        Serializable var3= new Serializable() {\n");
        buf.append("            int var4; \n");
        buf.append("        };\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test3.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test3 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    public void test() {\n");
        buf.append("        Serializable var3= new Serializable() {\n");
        buf.append("            private static final long serialVersionUID = 1L;\n");
        buf.append("            int var4; \n");
        buf.append("        };\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test3 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    public void test() {\n");
        buf.append("        Serializable var3= new Serializable() {\n");
        buf.append("            private static final long serialVersionUID = -868523843598659436L;\n");
        buf.append("            int var4; \n");
        buf.append("        };\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testInnerClass() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test2", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("\n");
        buf.append("public class Test2 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    protected class Test1 implements Serializable {\n");
        buf.append("        public long var3;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test2.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("\n");
        buf.append("public class Test2 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    protected class Test1 implements Serializable {\n");
        buf.append("        private static final long serialVersionUID = 1L;\n");
        buf.append("        public long var3;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package test2;\n");
        buf.append("\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("\n");
        buf.append("public class Test2 {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("    protected class Test1 implements Serializable {\n");
        buf.append("        private static final long serialVersionUID = -4023230086280104302L;\n");
        buf.append("        public long var3;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testOuterClass() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test1.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    private static final long serialVersionUID = 1L;\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    private static final long serialVersionUID = -2242798150684569765L;\n");
        buf.append("    protected int var1;\n");
        buf.append("    protected int var2;\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testOuterClass2() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test3", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.util.EventObject;\n");
        buf.append("public class Test4 extends EventObject {\n");
        buf.append("    private static final int x;\n");
        buf.append("    private static Class[] a2;\n");
        buf.append("    private volatile Class a1;\n");
        buf.append("    static {\n");
        buf.append("        x= 1;\n");
        buf.append("    }\n");
        buf.append("    {\n");
        buf.append("        a1= null;\n");
        buf.append("    }\n");
        buf.append("    \n");
        buf.append("    public Test4(Object source) {\n");
        buf.append("        super(source);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test4.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.util.EventObject;\n");
        buf.append("public class Test4 extends EventObject {\n");
        buf.append("    private static final long serialVersionUID = 1L;\n");
        buf.append("    private static final int x;\n");
        buf.append("    private static Class[] a2;\n");
        buf.append("    private volatile Class a1;\n");
        buf.append("    static {\n");
        buf.append("        x= 1;\n");
        buf.append("    }\n");
        buf.append("    {\n");
        buf.append("        a1= null;\n");
        buf.append("    }\n");
        buf.append("    \n");
        buf.append("    public Test4(Object source) {\n");
        buf.append("        super(source);\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package test3;\n");
        buf.append("import java.util.EventObject;\n");
        buf.append("public class Test4 extends EventObject {\n");
        buf.append("    private static final long serialVersionUID = -7476608308201363525L;\n");
        buf.append("    private static final int x;\n");
        buf.append("    private static Class[] a2;\n");
        buf.append("    private volatile Class a1;\n");
        buf.append("    static {\n");
        buf.append("        x= 1;\n");
        buf.append("    }\n");
        buf.append("    {\n");
        buf.append("        a1= null;\n");
        buf.append("    }\n");
        buf.append("    \n");
        buf.append("    public Test4(Object source) {\n");
        buf.append("        super(source);\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testOuterClass3() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("a.b.c", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package a.b.c;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    protected int var1;\n");
        buf.append("    class Test1Inner {}\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("Test1.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package a.b.c;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    private static final long serialVersionUID = 1L;\n");
        buf.append("    protected int var1;\n");
        buf.append("    class Test1Inner {}\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected("Add default serial version ID", buf.toString());
        buf = new StringBuilder();
        buf.append("package a.b.c;\n");
        buf.append("import java.io.Serializable;\n");
        buf.append("public class Test1 implements Serializable {\n");
        buf.append("    private static final long serialVersionUID = -3715240305486851194L;\n");
        buf.append("    protected int var1;\n");
        buf.append("    class Test1Inner {}\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected("Add generated serial version ID", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }
}

