/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.junit.Assert;
import org.junit.Test;

public class BasicFileDetectorTest {
    @Test
    public void testScanBuildFileAtRootExcludingNestedDirs() throws Exception {
        BasicFileDetector detector = new BasicFileDetector(Paths.get("projects/buildfiles", new String[0]), "buildfile").includeNested(false);
        Collection dirs = detector.scan(null);
        Assert.assertEquals((String)("Found " + dirs), (long)1L, (long)dirs.size());
        Assert.assertEquals((Object)FilenameUtils.separatorsToSystem((String)"projects/buildfiles"), (Object)((Path)dirs.iterator().next()).toString());
    }

    @Test
    public void testScanBuildFileAtRootIncludingNestedDirs() throws Exception {
        BasicFileDetector detector = new BasicFileDetector(Paths.get("projects/buildfiles/", new String[0]), "buildfile");
        Collection dirs = detector.scan(null);
        Assert.assertEquals((String)("Found " + dirs), (long)6L, (long)dirs.size());
        List<String> missingDirs = this.separatorsToSystem(this.list("projects/buildfiles", "projects/buildfiles/parent/1_0/0_2_0", "projects/buildfiles/parent/1_0/0_2_1", "projects/buildfiles/parent/1_1", "projects/buildfiles/parent/1_1/1_2_0", "projects/buildfiles/parent/1_1/1_2_1"));
        dirs.stream().map(Path::toString).forEach(missingDirs::remove);
        Assert.assertEquals((String)("Directories were not detected" + missingDirs), (long)0L, (long)missingDirs.size());
    }

    private List<String> separatorsToSystem(List<String> paths) {
        return paths.stream().map(p -> FilenameUtils.separatorsToSystem((String)p)).collect(Collectors.toList());
    }

    @Test
    public void testScanExcludingNestedBuildFilesDepth3() throws Exception {
        BasicFileDetector detector = new BasicFileDetector(Paths.get("projects/buildfiles/parent", new String[0]), "buildfile").includeNested(false).maxDepth(3);
        Collection dirs = detector.scan(null);
        Assert.assertEquals((String)("Found " + dirs), (long)3L, (long)dirs.size());
        List<String> missingDirs = this.separatorsToSystem(this.list("projects/buildfiles/parent/1_1", "projects/buildfiles/parent/1_0/0_2_0", "projects/buildfiles/parent/1_0/0_2_1"));
        dirs.stream().map(Path::toString).forEach(missingDirs::remove);
        Assert.assertEquals((String)("Directories were not detected" + missingDirs), (long)0L, (long)missingDirs.size());
    }

    @Test
    public void testScanNestedBuildFilesDepth2() throws Exception {
        BasicFileDetector detector = new BasicFileDetector(Paths.get("projects/buildfiles/parent", new String[0]), "buildfile").includeNested(false).maxDepth(2);
        Collection dirs = detector.scan(null);
        Assert.assertEquals((String)("Found " + dirs), (long)1L, (long)dirs.size());
        Assert.assertEquals((Object)FilenameUtils.separatorsToSystem((String)"projects/buildfiles/parent/1_1"), (Object)((Path)dirs.iterator().next()).toString());
    }

    @SafeVarargs
    private final <E> List<E> list(E ... elements) {
        return new ArrayList<E>(Arrays.asList(elements));
    }
}

