/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractGradleBasedTest;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.GradleProjectImporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class GradleProjectImporterTest
extends AbstractGradleBasedTest {
    private static final String GRADLE1_PATTERN = "**/gradle1";

    @Test
    public void importSimpleGradleProject() throws Exception {
        this.importSimpleJavaProject();
    }

    @Override
    @After
    public void cleanUp() throws Exception {
        super.cleanUp();
        Job.getJobManager().join((Object)"org.eclipse.buildship.core.jobs", (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void importNestedGradleProject() throws Exception {
        List<IProject> projects = this.importProjects("gradle/nested");
        Assert.assertEquals((long)3L, (long)projects.size());
        IProject gradle1 = WorkspaceHelper.getProject("gradle1");
        this.assertIsGradleProject(gradle1);
        IProject gradle2 = WorkspaceHelper.getProject("gradle2");
        this.assertIsGradleProject(gradle2);
    }

    @Test
    public void testJavaImportExclusions() throws Exception {
        List javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        try {
            javaImportExclusions.add(GRADLE1_PATTERN);
            List<IProject> projects = this.importProjects("gradle/nested");
            Assert.assertEquals((long)2L, (long)projects.size());
            IProject gradle1 = WorkspaceHelper.getProject("gradle1");
            Assert.assertNull((Object)gradle1);
            IProject gradle2 = WorkspaceHelper.getProject("gradle2");
            this.assertIsGradleProject(gradle2);
        }
        finally {
            javaImportExclusions.remove(GRADLE1_PATTERN);
        }
    }

    @Test
    public void testDisableGradle() throws Exception {
        boolean enabled = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isImportGradleEnabled();
        try {
            JavaLanguageServerPlugin.getPreferencesManager().getPreferences().setImportGradleEnabled(false);
            List<IProject> projects = this.importProjects("eclipse/eclipsegradle");
            Assert.assertEquals((long)2L, (long)projects.size());
            IProject eclipse = WorkspaceHelper.getProject("eclipse");
            Assert.assertNotNull((Object)eclipse);
            Assert.assertFalse((String)(String.valueOf(eclipse.getName()) + " has the Gradle nature"), (boolean)ProjectUtils.isGradleProject((IProject)eclipse));
        }
        finally {
            JavaLanguageServerPlugin.getPreferencesManager().getPreferences().setImportGradleEnabled(enabled);
        }
    }

    @Test
    public void testGradlePersistence() throws Exception {
        IProject project2;
        this.importProjects("gradle/nested");
        List projects = ProjectUtils.getGradleProjects();
        for (IProject project2 : projects) {
            Assert.assertTrue((boolean)GradleProjectImporter.shouldSynchronize((File)project2.getLocation().toFile()));
        }
        Job.getJobManager().join((Object)"org.eclipse.buildship.core.jobs", (IProgressMonitor)new NullProgressMonitor());
        GradleBuildSupport.saveModels();
        for (IProject project2 : projects) {
            Assert.assertFalse((boolean)GradleProjectImporter.shouldSynchronize((File)project2.getLocation().toFile()));
        }
        project2 = WorkspaceHelper.getProject("gradle1");
        File gradleBuild = new File(project2.getLocation().toFile(), "build.gradle");
        gradleBuild.setLastModified(System.currentTimeMillis() + 1000L);
        Assert.assertTrue((boolean)GradleProjectImporter.shouldSynchronize((File)project2.getLocation().toFile()));
    }

    @Test
    public void testWorkspaceSettings() throws Exception {
        HashMap env = new HashMap();
        Properties sysprops = new Properties();
        File file = null;
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File rootFile = root.getLocation().toFile();
            file = new File(rootFile, "fakeGradleHome");
            sysprops.setProperty("GRADLE_HOME", file.getAbsolutePath());
            boolean overrideWorkspaceSettings = GradleProjectImporter.getGradleHomeFile(env, (Properties)sysprops) != null;
            Assert.assertFalse((boolean)overrideWorkspaceSettings);
            file.mkdir();
            file.deleteOnExit();
            overrideWorkspaceSettings = GradleProjectImporter.getGradleHomeFile(env, (Properties)sysprops) != null;
            Assert.assertTrue((boolean)overrideWorkspaceSettings);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

