/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core.configuration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.service.core.ServiceMessages;
import org.eclipse.m2m.atl.service.core.ServiceTransformationUtil;
import org.eclipse.m2m.atl.service.core.configuration.TransformationConfiguration;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;
import org.eclipse.m2m.atl.service.core.nestedElements.Model;
import org.eclipse.m2m.atl.service.core.nestedElements.ModelToSave;
import org.eclipse.m2m.atl.service.core.nestedElements.Transformation;

public class ComposedTransformationConfiguration
extends TransformationConfiguration {
    private List transformations = new ArrayList();
    private List applyMarker;
    private Map modelsToSave = new HashMap();

    public ComposedTransformationConfiguration(String configurationName, String pluginId) {
        super(configurationName, pluginId);
        this.applyMarker = new ArrayList();
    }

    public void addTransformation(Transformation t) {
        this.transformations.add(t);
    }

    public void addInModel(String name, String path, String metamodel, boolean inWorkspace) {
        if (inWorkspace) {
            this.models.put(name, new Model(name, metamodel, "EMF"));
        } else {
            try {
                this.models.put(name, new Model(name, ((Model)this.models.get(metamodel)).getAsmModel(), path, null, false, "EMF", this.pluginId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addMetamodel(String name, String path, String nsUri, boolean isM3, String modelHandler) {
        try {
            this.models.put(name, new Model(name, AtlModelHandler.getDefault((String)modelHandler).getMof(), path, nsUri, isM3, modelHandler, this.pluginId));
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void addModelToSave(String name, String fileName) {
        this.modelsToSave.put(name, new ModelToSave(name, fileName));
    }

    public void addModelToSave(String name, String fileName, String extractorType, Map extractorParams) {
        this.modelsToSave.put(name, new ModelToSave(name, fileName, extractorType, extractorParams));
    }

    public void addApplyMarker(String modelProblemName) {
        this.applyMarker.add(modelProblemName);
    }

    public void execute(String pathFolder, String pathInModel) throws ServiceException {
        for (Transformation t : this.transformations) {
            if (t.getModelsNotPreloaded().size() == 1) {
                this.loadModel(t, pathInModel);
            }
            this.executeTransformation(t);
        }
        for (String modelName : this.applyMarker) {
            Model currentOutModel = (Model)this.models.get(modelName);
            try {
                ServiceTransformationUtil.applyMarkers(pathInModel, currentOutModel.getAsmModel());
            }
            catch (CoreException e) {
                throw new ServiceException(4, (Exception)((Object)e));
            }
        }
        for (String modelName : this.modelsToSave.keySet()) {
            this.saveModel(pathFolder, modelName);
        }
    }

    public void loadModel(Transformation transformation, String pathInModel) throws ServiceException {
        ((Model)this.models.get(transformation.getModelsNotPreloaded().get(0))).loadModel(pathInModel, ((Model)this.models.get(((Model)this.models.get(transformation.getModelsNotPreloaded().get(0))).getMetamodelName())).getAsmModel(), this.pluginId);
    }

    public void executeTransformation(Transformation transformation) throws ServiceException {
        Map params = Collections.EMPTY_MAP;
        HashMap libs = new HashMap();
        ArrayList superimps = new ArrayList();
        URL asmUrl = ServiceTransformationUtil.getURLFromASMFile(transformation.getTransformationPath(), this.pluginId);
        for (String modelName : transformation.getOutModelsForLoading().keySet()) {
            this.models.put(modelName, new Model(modelName, ((Model)this.models.get(transformation.getOutModelsForLoading().get(modelName))).getAsmModel(), modelName, "EMF"));
        }
        AtlLauncher.getDefault().launch(asmUrl, libs, this.getModelsForTransformation(transformation), params, superimps, Collections.EMPTY_MAP);
    }

    public void saveModel(String pathFolder, String modelName) throws ServiceException {
        ModelToSave mts = (ModelToSave)this.modelsToSave.get(modelName);
        Model currentOutModel = (Model)this.models.get(modelName);
        if (!mts.isExtractor()) {
            AtlModelHandler.getDefault((String)"EMF").saveModel(currentOutModel.getAsmModel(), String.valueOf(pathFolder) + "/" + mts.getFileName());
        } else if (mts.getExtractorType().equals("XML")) {
            ServiceTransformationUtil.xmlExtraction(currentOutModel.getAsmModel(), String.valueOf(pathFolder) + "/" + mts.getFileName(), AtlModelHandler.getDefault((String)"EMF"));
        } else if (mts.getExtractorType().equals("EBNF")) {
            Map params = mts.getExtractorParams();
            ServiceTransformationUtil.ebnfExtraction(currentOutModel.getAsmModel(), String.valueOf(pathFolder) + "/" + mts.getFileName(), AtlModelHandler.getDefault((String)"EMF"), params);
        } else {
            throw new ServiceException(4, ServiceMessages.getString("ComposedTransformationConfiguration.0", new Object[]{mts.getExtractorType()}));
        }
    }
}

