/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFExtractor
implements IExtractor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extract(IModel sourceModel, String target, Map<String, Object> options) throws ATLCoreException {
        if (target == null) throw new ATLCoreException(Messages.getString("EMFExtractor.NO_PATH"));
        if (((EMFModel)sourceModel).getResource() == null) throw new ATLCoreException(Messages.getString("EMFExtractor.NO_RESOURCE", target));
        EMFExtractor.recreateResourceIfNeeded((EMFModel)sourceModel, URI.createURI((String)target));
        HashMap<String, Object> extractOptions = new HashMap<String, Object>();
        extractOptions.put("ENCODING", "ISO-8859-1");
        extractOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        if (options != null) {
            extractOptions.putAll(options);
        }
        try {
            ((EMFModel)sourceModel).getResource().save(extractOptions);
            return;
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void extract(IModel sourceModel, String target) throws ATLCoreException {
        this.extract(sourceModel, target, Collections.<String, Object>emptyMap());
    }

    public void extract(EMFModel sourceModel, OutputStream target, String fileExtension, Map<String, Object> options) throws ATLCoreException {
        EMFExtractor.recreateResourceIfNeeded(sourceModel, URI.createURI((String)("tmp." + fileExtension)));
        this.extract((IModel)sourceModel, target, options);
    }

    public void extract(IModel sourceModel, OutputStream target, Map<String, Object> options) throws ATLCoreException {
        HashMap<String, Object> extractOptions = new HashMap<String, Object>();
        extractOptions.put("ENCODING", "ISO-8859-1");
        extractOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        if (options != null) {
            extractOptions.putAll(options);
        }
        try {
            if (((EMFModel)sourceModel).getResource() == null) {
                throw new ATLCoreException(Messages.getString("EMFExtractor.NO_RESOURCE", "OutputStream"));
            }
            ((EMFModel)sourceModel).getResource().save(target, extractOptions);
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected static void recreateResourceIfNeeded(EMFModel model, URI uri) {
        if (model.getEmfResourceFactory() == null) {
            ResourceSet resourceSet = model.getModelFactory().getResourceSet();
            Resource newResource = resourceSet.createResource(uri);
            newResource.getContents().addAll((Collection)model.getResource().getContents());
            model.setResource(newResource);
        } else {
            model.getResource().setURI(uri);
        }
    }
}

