/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class RealizedPartition
extends AbstractPartition {
    public RealizedPartition(@NonNull MappingPartitioner partitioner) {
        super(partitioner);
        Iterable<@NonNull Node> predicatedMiddleNodes = partitioner.getPredicatedMiddleNodes();
        assert (Iterables.isEmpty(predicatedMiddleNodes));
        this.addLoadedNavigationEdgeSourceAndTargetNodes();
        for (Node node : partitioner.getTraceNodes()) {
            if (this.hasNode(node)) continue;
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
        }
        for (Node node : partitioner.getRealizedOutputNodes()) {
            if (this.hasNode(node)) continue;
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
        }
        this.resolveTrueNodes();
        this.resolvePrecedingNodes();
        this.resolveEdges();
    }

    protected void addLoadedNavigationEdgeSourceAndTargetNodes() {
        for (NavigableEdge edge : this.region.getNavigationEdges()) {
            if (!edge.isLoaded()) continue;
            Node sourceNode = edge.getEdgeSource();
            Node targetNode = edge.getEdgeTarget();
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return null;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) assert (!this.partitioner.hasRealizedEdge(edge));
        return edgeRole;
    }
}

