/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.ActivatorPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.ResidualPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.WhenPartitionFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

public class DefaultPartitioningStrategy
extends AbstractPartitioningStrategy {
    protected final @NonNull List<@NonNull Node> realizedWhenNodes;
    protected final List<@NonNull Node> predicatedWhenNodes;

    public DefaultPartitioningStrategy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull MappingPartitioner mappingPartitioner) {
        super(partitionedTransformationAnalysis, mappingPartitioner);
        assert (this.scheduleManager.useActivators());
        this.realizedWhenNodes = mappingPartitioner.getRealizedWhenNodes();
        this.predicatedWhenNodes = mappingPartitioner.getPredicatedWhenNodes();
    }

    @Override
    public @NonNull Iterable<@NonNull PartitionAnalysis> partition() {
        boolean needsSpeculation;
        this.createActivatorPartition();
        this.createWhenPartitions();
        boolean isCyclic = this.transformationAnalysis.basicGetCyclicRegionAnalysis(this.regionAnalysis) != null;
        boolean hasPredication = this.predicatedWhenNodes.size() > 0 || this.realizedWhenNodes.size() > 0;
        boolean bl = needsSpeculation = isCyclic && hasPredication;
        if (!needsSpeculation) {
            if (this.newPartitionAnalyses.isEmpty()) {
                this.createNonPartition();
            } else {
                this.createResidualPartition();
            }
        } else {
            this.createSpeculationPartitions();
            this.createAssignmentPartitions();
        }
        this.check();
        return this.newPartitionAnalyses;
    }

    protected void createNonPartition() {
        this.newPartitionAnalyses.add(new NonPartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis));
    }

    protected void createActivatorPartition() {
        List<@NonNull Node> realizedExecutionNodes = this.mappingPartitioner.getRealizedExecutionNodes();
        if (realizedExecutionNodes.size() > 0) {
            this.newPartitionAnalyses.add(new ActivatorPartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis));
        }
    }

    protected void createResidualPartition() {
        this.newPartitionAnalyses.add(new ResidualPartitionFactory(this.mappingPartitioner).createPartitionAnalysis(this.partitionedTransformationAnalysis));
    }

    protected void createWhenPartitions() {
        if (this.realizedWhenNodes.size() > 0) {
            this.newPartitionAnalyses.add(new WhenPartitionFactory(this.mappingPartitioner, this.useActivators()).createPartitionAnalysis(this.partitionedTransformationAnalysis));
        }
    }

    @Override
    protected boolean useActivators() {
        return true;
    }
}

