/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationRunnerFactory {
    public String transformationURI;
    public List<String> modelParamURI;
    public String traceFileURI;
    public EPackage.Registry packageRegistry;

    public TransformationRunner createRunner() throws DiagnosticException {
        BasicDiagnostic diagnostic = QvtPlugin.createDiagnostic((String)"Transformation runner problems");
        URI uri = null;
        try {
            uri = this.toURI(this.transformationURI, "transformation");
        }
        catch (DiagnosticException e) {
            diagnostic.add(e.getDiagnostic());
        }
        ArrayList<URI> paramURIs = new ArrayList<URI>();
        if (this.modelParamURI != null && !this.modelParamURI.isEmpty()) {
            for (String paramURIStr : this.modelParamURI) {
                try {
                    paramURIs.add(this.toURI(paramURIStr, "model parameter"));
                }
                catch (DiagnosticException e) {
                    diagnostic.add(e.getDiagnostic());
                }
            }
        } else {
            diagnostic.add(QvtPlugin.createErrorDiagnostic((String)"No model parameters passed to transformation", null));
        }
        if (diagnostic.getSeverity() == 4) {
            throw new DiagnosticException((Diagnostic)diagnostic);
        }
        assert (uri != null && paramURIs != null && !paramURIs.isEmpty());
        EPackage.Registry registry = this.packageRegistry != null ? this.packageRegistry : EPackage.Registry.INSTANCE;
        TransformationRunner runner = this.createRunner(uri, registry, paramURIs);
        if (this.traceFileURI != null) {
            try {
                runner.setTraceFile(this.toURI(this.traceFileURI, "trace file"));
            }
            catch (DiagnosticException e) {
                diagnostic.add(e.getDiagnostic());
            }
        }
        return runner;
    }

    protected TransformationRunner createRunner(URI transformationURI, EPackage.Registry packageRegistry, List<URI> modelParamURIs) {
        return new TransformationRunner(transformationURI, packageRegistry, modelParamURIs);
    }

    private URI toURI(String uriStr, String uriType) throws DiagnosticException {
        IllegalArgumentException exc = null;
        if (uriStr != null) {
            try {
                return URI.createURI((String)uriStr);
            }
            catch (IllegalArgumentException e) {
                exc = e;
            }
        }
        String message = NLS.bind((String)"Invalid {0} URI : ''{1}''", (Object)uriType, (Object)uriStr);
        throw new DiagnosticException(QvtPlugin.createErrorDiagnostic((String)message, (Throwable)exc));
    }
}

