/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.actions.collapse.CollapseAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.actions.expand.ExpandAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFSynchronizationModel;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DiffNodeComparer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.compare.ide.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.GroupActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterSelectionChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class EMFCompareStructureMergeViewer
extends DiffTreeViewer
implements CommandStackListener {
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private final ComposedAdapterFactory fAdapterFactory;
    private final CompareViewerSwitchingPane fParent;
    private Object fRoot;
    private StructureMergeViewerFilter structureMergeViewerFilter;
    private StructureMergeViewerGrouper structureMergeViewerGrouper;
    private MenuManager groupsMenuManager;
    private MenuManager filtersMenuManager;
    private GroupActionMenu groupActionMenu;
    private DefaultGroupProvider defaultGroupProvider;
    private FilterActionMenu filterActionMenu;
    private EventBus eventBus;
    private boolean resourcesShouldBeUnload;
    private Job inputChangedTask = new Job("Compute Model Differences"){

        public IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing Model Differences", (int)100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)subMonitor.newChild(100));
            return Status.OK_STATUS;
        }
    };

    public EMFCompareStructureMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider((AdapterFactory)this.fAdapterFactory, (Viewer)this)));
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider((AdapterFactory)this.fAdapterFactory, this.structureMergeViewerGrouper, this.structureMergeViewerFilter, configuration));
        this.fParent = parent instanceof CompareViewerSwitchingPane ? (CompareViewerSwitchingPane)parent : null;
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.setComparer(new DiffNodeComparer(super.getComparer()));
        if (this.eventBus == null) {
            this.eventBus = new EventBus();
            this.eventBus.register((Object)this);
        }
        this.inputChangedTask.setPriority(30);
    }

    public ViewerComparator getComparator() {
        return null;
    }

    @Subscribe
    public void recordFilterSelectionChange(IDifferenceFilterSelectionChangeEvent event) {
        Object property = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS");
        HashSet<IDifferenceFilter> selectedFilters = property == null ? new HashSet<IDifferenceFilter>() : (HashSet<IDifferenceFilter>)property;
        switch (event.getAction()) {
            case ACTIVATE: {
                selectedFilters.add(event.getFilter());
                break;
            }
            case DEACTIVATE: {
                selectedFilters.remove(event.getFilter());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS", selectedFilters);
    }

    @Subscribe
    public void recordGroupProviderSelectionChange(IDifferenceGroupProvider differenceGroupProvider) {
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP", (Object)differenceGroupProvider);
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            this.inputChangedTask.schedule();
        }
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    private Subscriber getSubscriber() {
        if (this.getCompareConfiguration().getContainer() instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput modelInput = (ModelCompareEditorInput)this.getCompareConfiguration().getContainer();
            ISynchronizeParticipant participant = null;
            try {
                final Field field = ModelCompareEditorInput.class.getDeclaredField("participant");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                participant = (ISynchronizeParticipant)field.get(modelInput);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (participant instanceof ModelSynchronizeParticipant && ((ModelSynchronizeParticipant)participant).getContext() instanceof SubscriberMergeContext) {
                return ((SubscriberMergeContext)((ModelSynchronizeParticipant)participant).getContext()).getSubscriber();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        block17: {
            block18: {
                block16: {
                    if (input == null) break block16;
                    if (input instanceof ComparisonNode) {
                        this.resourcesShouldBeUnload = false;
                        this.compareInputChanged((ComparisonNode)input, monitor);
                    } else if (input instanceof ComparisonScopeInput) {
                        this.resourcesShouldBeUnload = false;
                        this.compareInputChanged((ComparisonScopeInput)input, monitor);
                    } else {
                        this.resourcesShouldBeUnload = true;
                        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        left = input.getLeft();
                        right = input.getRight();
                        origin = input.getAncestor();
                        subscriber = this.getSubscriber();
                        syncModel = EMFSynchronizationModel.createSynchronizationModel(subscriber, left, right, origin, (IProgressMonitor)subMonitor.newChild(10));
                        config = this.getCompareConfiguration();
                        if (!syncModel.isLeftEditable()) {
                            config.setLeftEditable(false);
                        }
                        if (!syncModel.isRightEditable()) {
                            config.setRightEditable(false);
                        }
                        scope = syncModel.createMinimizedScope((IProgressMonitor)subMonitor.newChild(75));
                        compareResult = EMFCompare.builder().setMatchEngineFactoryRegistry(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry()).setPostProcessorRegistry(EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry()).build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(15)));
                        leftResourceSet = (ResourceSet)scope.getLeft();
                        rightResourceSet = (ResourceSet)scope.getRight();
                        originResourceSet = (ResourceSet)scope.getOrigin();
                        if (this.getCompareConfiguration() != null) {
                            editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
                            if (editingDomain != null) {
                                editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
                                editingDomain.dispose();
                            }
                            editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                            editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
                            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN", (Object)editingDomain);
                        }
                        this.compareInputChanged(scope, compareResult);
                    }
                    break block17;
                }
                leftResourceSet = null;
                rightResourceSet = null;
                originResourceSet = null;
                if (this.fRoot == null) break block18;
                comparison = (Comparison)((Adapter)this.fRoot).getTarget();
                matchIt = comparison.getMatches().iterator();
                if (!comparison.isThreeWay()) ** GOTO lbl60
                while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet == null) {
                        rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                    }
                    if (originResourceSet != null) continue;
                    originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
                }
                break block18;
lbl-1000:
                // 1 sources

                {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet != null) continue;
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl60:
                    // 3 sources

                    ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
                }
            }
            if ((editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN")) != null) {
                editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN", null);
                editingDomain.dispose();
                editingDomain = null;
            }
            if (this.resourcesShouldBeUnload) {
                EMFCompareStructureMergeViewer.unload(leftResourceSet);
                EMFCompareStructureMergeViewer.unload(rightResourceSet);
                EMFCompareStructureMergeViewer.unload(originResourceSet);
            }
            if (this.getCompareConfiguration() != null) {
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP", null);
            }
            this.fRoot = null;
        }
    }

    void compareInputChanged(ComparisonNode input, IProgressMonitor monitor) {
        ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
        editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.compareInputChanged(null, input.getTarget());
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
        editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        EMFCompare comparator = (EMFCompare)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARATOR");
        IComparisonScope comparisonScope = input.getComparisonScope();
        Comparison comparison = comparator.compare(comparisonScope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        this.compareInputChanged(input.getComparisonScope(), comparison);
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    void compareInputChanged(final IComparisonScope scope, final Comparison comparison) {
        if (!this.getControl().isDisposed()) {
            this.fRoot = this.fAdapterFactory.adapt((Notifier)comparison, ICompareInput.class);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT", (Object)comparison);
            String message = null;
            if (comparison.getDifferences().isEmpty()) {
                message = "No Differences";
            }
            final String theMessage = message;
            SWTUtil.safeAsyncExec(new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.groupActionMenu.createActions(scope, comparison);
                    EMFCompareStructureMergeViewer.this.filterActionMenu.createActions(scope, comparison);
                    EMFCompareStructureMergeViewer.this.refreshAfterDiff(theMessage, EMFCompareStructureMergeViewer.this.fRoot);
                    EMFCompareStructureMergeViewer.this.initialSelection();
                }
            });
        }
    }

    public boolean isExpandable(Object parent) {
        if (this.hasFilters()) {
            return this.hasFilteredChildren(parent);
        }
        return super.isExpandable(parent);
    }

    public final boolean hasFilteredChildren(Object parent) {
        Object[] rawChildren = this.getRawChildren(parent);
        return this.containsNonFiltered(rawChildren, parent);
    }

    private boolean containsNonFiltered(Object[] elements, Object parent) {
        if (elements.length == 0) {
            return false;
        }
        if (!this.hasFilters()) {
            return true;
        }
        ViewerFilter[] filters = this.getFilters();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (!this.isFiltered(object, parent, filters)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (!filter.select((Viewer)this, parent, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void refreshAfterDiff(String message, Object root) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(root);
    }

    public void setComparer(IElementComparer comparer) {
        super.setComparer((IElementComparer)new DiffNodeComparer(comparer));
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        super.createToolItems(toolbarManager);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolbarManager, "toolbar:org.eclipse.emf.compare.structuremergeviewer.toolbar");
        }
        Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        Version junoStart = Version.parseVersion((String)"3.103");
        Version keplerStart = Version.parseVersion((String)"3.105");
        if (uiWorkbenchBundle != null && uiWorkbenchBundle.getVersion().compareTo(junoStart) >= 0 && uiWorkbenchBundle.getVersion().compareTo(keplerStart) < 0) {
            CommandAction action = new CommandAction((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.emf.compare.ide.ui.saveComparisonModel");
            action.setToolTipText("Save Comparison model");
            action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/saveas_edit.gif"));
            toolbarManager.add((IAction)action);
        }
        this.groupActionMenu = new GroupActionMenu(this.getStructureMergeViewerGrouper(), this.getGroupsMenuManager(), this.getDefaultGroupProvider());
        this.filterActionMenu = new FilterActionMenu(this.getStructureMergeViewerFilter(), this.getFiltersMenuManager());
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new ExpandAllModelAction((AbstractTreeViewer)this));
        toolbarManager.add((IAction)new CollapseAllModelAction((AbstractTreeViewer)this));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.groupActionMenu);
        toolbarManager.add((IAction)this.filterActionMenu);
    }

    protected StructureMergeViewerFilter getStructureMergeViewerFilter() {
        if (this.structureMergeViewerFilter == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerFilter = new StructureMergeViewerFilter(this.eventBus);
            this.structureMergeViewerFilter.install((TreeViewer)this);
        }
        return this.structureMergeViewerFilter;
    }

    protected StructureMergeViewerGrouper getStructureMergeViewerGrouper() {
        if (this.structureMergeViewerGrouper == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerGrouper = new StructureMergeViewerGrouper(this.eventBus);
            this.structureMergeViewerGrouper.install((TreeViewer)this);
        }
        return this.structureMergeViewerGrouper;
    }

    public MenuManager getGroupsMenuManager() {
        if (this.groupsMenuManager == null) {
            this.groupsMenuManager = new MenuManager();
        }
        return this.groupsMenuManager;
    }

    public MenuManager getFiltersMenuManager() {
        if (this.filtersMenuManager == null) {
            this.filtersMenuManager = new MenuManager();
        }
        return this.filtersMenuManager;
    }

    public DefaultGroupProvider getDefaultGroupProvider() {
        if (this.defaultGroupProvider == null) {
            this.defaultGroupProvider = new DefaultGroupProvider();
        }
        return this.defaultGroupProvider;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            TreeItem item = new TreeItem(this.getTree(), 0);
            item.setText("Computing model differences...");
            this.compareInputChanged(ci);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged(null);
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand instanceof ICompareCopyCommand) {
            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
            SWTUtil.safeAsyncExec(new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.refresh(true);
                }
            });
            if (!affectedObjects.isEmpty()) {
                final Object adaptedAffectedObject = this.fAdapterFactory.adapt(Iterables.getFirst((Iterable)affectedObjects, null), ICompareInput.class);
                SWTUtil.safeAsyncExec(new Runnable(){

                    public void run() {
                        EMFCompareStructureMergeViewer.this.setSelectionToWidget((ISelection)new StructuredSelection(adaptedAffectedObject), true);
                    }
                });
            }
        }
    }

    protected Object[] getSortedChildren(Object parentElementOrTreePath) {
        Object[] result = super.getSortedChildren(parentElementOrTreePath);
        if (parentElementOrTreePath instanceof Adapter && ((Adapter)parentElementOrTreePath).getTarget() instanceof Conflict) {
            Collections.sort(Arrays.asList(result), new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return this.getValue(o1) - this.getValue(o2);
                }

                public int getValue(Object o) {
                    int value = 0;
                    if (o instanceof Adapter && ((Adapter)o).getTarget() instanceof Diff) {
                        value = ((Diff)((Adapter)o).getTarget()).getSource() == DifferenceSource.LEFT ? 1 : 2;
                    }
                    return value;
                }
            });
        }
        return result;
    }
}

