/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompare {
    private final IMatchEngine.Factory.Registry matchEngineFactoryRegistry;
    private final IDiffEngine diffEngine;
    private final IReqEngine reqEngine;
    private final IEquiEngine equiEngine;
    private final IConflictDetector conflictDetector;
    private final IPostProcessor.Descriptor.Registry<?> postProcessorDescriptorRegistry;

    protected EMFCompare(IMatchEngine.Factory.Registry matchEngineFactoryRegistry, IDiffEngine diffEngine, IReqEngine reqEngine, IEquiEngine equiEngine, IConflictDetector conflictDetector, IPostProcessor.Descriptor.Registry<?> postProcessorFactoryRegistry) {
        this.matchEngineFactoryRegistry = (IMatchEngine.Factory.Registry)Preconditions.checkNotNull((Object)matchEngineFactoryRegistry);
        this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)diffEngine);
        this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)reqEngine);
        this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)equiEngine);
        this.conflictDetector = conflictDetector;
        this.postProcessorDescriptorRegistry = (IPostProcessor.Descriptor.Registry)Preconditions.checkNotNull(postProcessorFactoryRegistry);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right) {
        return new DefaultComparisonScope(left, right, null);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right, Notifier origin) {
        return new DefaultComparisonScope(left, right, origin);
    }

    public Comparison compare(IComparisonScope scope) {
        return this.compare(scope, (Monitor)new BasicMonitor());
    }

    public Comparison compare(IComparisonScope scope, Monitor monitor) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)monitor);
        Comparison comparison = this.matchEngineFactoryRegistry.getHighestRankingMatchEngineFactory(scope).getMatchEngine().match(scope, monitor);
        ImmutableList<IPostProcessor> postProcessors = this.postProcessorDescriptorRegistry.getPostProcessors(scope);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postMatch(comparison, monitor);
        }
        this.diffEngine.diff(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postDiff(comparison, monitor);
        }
        this.reqEngine.computeRequirements(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postRequirements(comparison, monitor);
        }
        this.equiEngine.computeEquivalences(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postEquivalences(comparison, monitor);
        }
        if (comparison.isThreeWay() && this.conflictDetector != null) {
            this.conflictDetector.detect(comparison, monitor);
            for (IPostProcessor iPostProcessor : postProcessors) {
                iPostProcessor.postConflicts(comparison, monitor);
            }
        }
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postComparison(comparison, monitor);
        }
        monitor.done();
        return comparison;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        protected IMatchEngine.Factory.Registry matchEngineFactoryRegistry;
        protected IReqEngine reqEngine;
        protected IDiffEngine diffEngine;
        protected IEquiEngine equiEngine;
        protected IConflictDetector conflictDetector;
        protected IPostProcessor.Descriptor.Registry<?> registry;

        protected Builder() {
        }

        public Builder setMatchEngineFactoryRegistry(IMatchEngine.Factory.Registry mefr) {
            this.matchEngineFactoryRegistry = (IMatchEngine.Factory.Registry)Preconditions.checkNotNull((Object)mefr);
            return this;
        }

        public Builder setDiffEngine(IDiffEngine de) {
            this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)de);
            return this;
        }

        public Builder setRequirementEngine(IReqEngine re) {
            this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)re);
            return this;
        }

        public Builder setEquivalenceEngine(IEquiEngine ee) {
            this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)ee);
            return this;
        }

        public Builder setConflictDetector(IConflictDetector cd) {
            this.conflictDetector = (IConflictDetector)Preconditions.checkNotNull((Object)cd);
            return this;
        }

        public Builder setPostProcessorRegistry(IPostProcessor.Descriptor.Registry<?> r) {
            this.registry = (IPostProcessor.Descriptor.Registry)Preconditions.checkNotNull(r);
            return this;
        }

        public EMFCompare build() {
            if (this.matchEngineFactoryRegistry == null) {
                this.matchEngineFactoryRegistry = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
            }
            if (this.diffEngine == null) {
                this.diffEngine = new DefaultDiffEngine(new DiffBuilder());
            }
            if (this.reqEngine == null) {
                this.reqEngine = new DefaultReqEngine();
            }
            if (this.equiEngine == null) {
                this.equiEngine = new DefaultEquiEngine();
            }
            if (this.registry == null) {
                this.registry = new PostProcessorDescriptorRegistryImpl();
            }
            if (this.conflictDetector == null) {
                this.conflictDetector = new DefaultConflictDetector();
            }
            return new EMFCompare(this.matchEngineFactoryRegistry, this.diffEngine, this.reqEngine, this.equiEngine, this.conflictDetector, this.registry);
        }
    }
}

