/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.IResourceContentsAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.ResourceAttachmentChangeMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContentsAccessorImpl
implements IResourceContentsAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final AdapterFactory fAdapterFactory;

    public ResourceContentsAccessorImpl(AdapterFactory adapterFactory, Diff diff, IMergeViewer.MergeViewerSide side) {
        this.fAdapterFactory = adapterFactory;
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        Match match;
        Diff initialDiff = this.fDiff;
        EObject diffValue = (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, this.getSide());
        if (diffValue == null && IMergeViewer.MergeViewerSide.ANCESTOR != this.getSide() && (diffValue = IMergeViewer.MergeViewerSide.LEFT == this.getSide() ? (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.RIGHT) : (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.LEFT)) == null) {
            diffValue = (EObject)MergeViewerUtil.getResourceAttachmentChangeValue((ResourceAttachmentChange)initialDiff, IMergeViewer.MergeViewerSide.ANCESTOR);
        }
        if ((match = this.getComparison().getMatch(diffValue)) != null) {
            return new MergeViewerItem.Container(this.getComparison(), initialDiff, match, this.getSide(), this.fAdapterFactory);
        }
        return null;
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList ret = ImmutableList.of((Object)new ResourceAttachmentChangeMergeViewerItem(this.getComparison(), null, this.getResource(IMergeViewer.MergeViewerSide.LEFT), this.getResource(IMergeViewer.MergeViewerSide.RIGHT), this.getResource(IMergeViewer.MergeViewerSide.ANCESTOR), this.getSide(), this.fAdapterFactory));
        return ret;
    }

    @Override
    public Resource getResource(IMergeViewer.MergeViewerSide side) {
        return MergeViewerUtil.getResource(this.fOwnerMatch.getComparison(), side, this.fDiff);
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public String getName() {
        return ResourceContentsAccessorImpl.class.getName();
    }

    @Override
    public Image getImage() {
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EObject"));
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eResourceDiff";
    }
}

