/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIDistance
implements Function<EObject, Iterable<String>> {
    private static final int MAX_DISTANCE = 10;
    private Cache<EObject, Iterable<String>> locationCache = CacheBuilder.newBuilder().maximumSize(10000).build(CacheLoader.from((Function)this));

    public int proximity(EObject a, EObject b) {
        Iterable aPath = (Iterable)this.locationCache.getUnchecked((Object)a);
        Iterable bPath = (Iterable)this.locationCache.getUnchecked((Object)b);
        return this.proximity(aPath, bPath);
    }

    public int proximity(Iterable<String> aPath, Iterable<String> bPath) {
        int aSize = 0;
        int bSize = 0;
        Iterator<String> itA = aPath.iterator();
        Iterator<String> itB = bPath.iterator();
        boolean areSame = true;
        int commonSegments = 0;
        int remainingASegments = 0;
        int remainingBSegments = 0;
        while (itA.hasNext() && itB.hasNext() && areSame) {
            String b;
            String a = itA.next();
            if (a.equals(b = itB.next())) {
                ++commonSegments;
            } else {
                areSame = false;
            }
            ++aSize;
            ++bSize;
        }
        if (commonSegments == 0) {
            return 10;
        }
        remainingASegments = aSize + Iterators.size(itA) - commonSegments;
        remainingBSegments = bSize + Iterators.size(itB) - commonSegments;
        int nbSegmentsToGoFromAToB = remainingASegments + remainingBSegments;
        return nbSegmentsToGoFromAToB * 10 / (commonSegments * 2 + nbSegmentsToGoFromAToB);
    }

    public Iterable<String> apply(EObject input) {
        EObject cur = input;
        String result = "";
        EObject container = input.eContainer();
        if (container != null) {
            EStructuralFeature feat = cur.eContainingFeature();
            if (input instanceof InternalEObject) {
                String frag;
                result = frag = ((InternalEObject)container).eURIFragmentSegment(feat, cur);
            }
        } else {
            result = "0";
        }
        if (input.eContainer() != null) {
            return Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{result}), (Iterable)((Iterable)this.locationCache.getUnchecked((Object)input.eContainer())));
        }
        return Lists.newArrayList((Object[])new String[]{result});
    }

    public int getUpperBoundDistance() {
        return 10;
    }
}

