/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.rcp.ui.internal.util.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EMFCompareRCPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.rcp.ui";
    public static final String GROUP_PROVIDER_PPID = "groups";
    public static final String FILTER_PROVIDER_PPID = "filters";
    private static EMFCompareRCPUIPlugin plugin;
    private static Map<String, Image> resourcesMapper;
    private AbstractRegistryEventListener groupProviderRegistryListener;
    private IDifferenceGroupProvider.Registry groupProviderRegistry;
    private AbstractRegistryEventListener filterRegistryListener;
    private IDifferenceFilter.Registry filterRegistry;

    static {
        resourcesMapper = new HashMap<String, Image>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.groupProviderRegistry = new IDifferenceGroupProvider.RegistryImpl();
        this.groupProviderRegistryListener = new DifferenceGroupProviderExtensionRegistryListener(PLUGIN_ID, GROUP_PROVIDER_PPID);
        extensionRegistry.addListener((IRegistryEventListener)this.groupProviderRegistryListener, "org.eclipse.emf.compare.rcp.ui.groups");
        this.groupProviderRegistryListener.readRegistry(extensionRegistry);
        this.filterRegistry = new IDifferenceFilter.RegistryImpl();
        this.filterRegistryListener = new FilterExtensionRegistryListener(PLUGIN_ID, FILTER_PROVIDER_PPID);
        extensionRegistry.addListener((IRegistryEventListener)this.filterRegistryListener, "org.eclipse.emf.compare.rcp.ui.filters");
        this.filterRegistryListener.readRegistry(extensionRegistry);
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this.filterRegistryListener);
        this.filterRegistry = null;
        Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this.groupProviderRegistryListener);
        this.groupProviderRegistry = null;
        plugin = null;
        EMFCompareRCPUIPlugin.disposeCachedImages();
        super.stop(context);
    }

    public static EMFCompareRCPUIPlugin getDefault() {
        return plugin;
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public IDifferenceGroupProvider.Registry getDifferenceGroupProviderRegistry() {
        return this.groupProviderRegistry;
    }

    public IDifferenceFilter.Registry getFilterActionRegistry() {
        return this.filterRegistry;
    }

    public static Image getImage(String imagePath) {
        Image image = resourcesMapper.get(imagePath);
        if (image == null) {
            ImageDescriptor imageDescriptor = EMFCompareRCPUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
            image = imageDescriptor.createImage();
            resourcesMapper.put(imagePath, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String imagePath) {
        return EMFCompareRCPUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
    }

    public static void disposeImage(String id) {
        Image image = resourcesMapper.remove(id);
        if (image != null) {
            image.dispose();
        }
    }

    public static void disposeCachedImages() {
        Iterator<Image> iterator = resourcesMapper.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        resourcesMapper.clear();
    }

    private class DifferenceGroupProviderExtensionRegistryListener
    extends AbstractRegistryEventListener {
        static final String TAG_GROUP_PROVIDER = "group";
        static final String ATT_CLASS = "class";
        static final String ATT_LABEL = "label";
        static final String ATT_ACTIVE = "activeByDefault";

        public DifferenceGroupProviderExtensionRegistryListener(String pluginID, String extensionPointID) {
            super(pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action b) {
            if (element.getName().equals(TAG_GROUP_PROVIDER)) {
                if (element.getAttribute(ATT_CLASS) == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                } else if (element.getAttribute(ATT_LABEL) == null) {
                    this.logMissingAttribute(element, ATT_LABEL);
                } else if (element.getAttribute(ATT_ACTIVE) == null) {
                    this.logMissingAttribute(element, ATT_ACTIVE);
                } else {
                    switch (b) {
                        case ADD: {
                            try {
                                IDifferenceGroupProvider provider = (IDifferenceGroupProvider)element.createExecutableExtension(ATT_CLASS);
                                provider.setLabel(element.getAttribute(ATT_LABEL));
                                if (Boolean.valueOf(element.getAttribute(ATT_ACTIVE)).booleanValue()) {
                                    provider.setDefaultSelected(true);
                                } else {
                                    provider.setDefaultSelected(false);
                                }
                                IDifferenceGroupProvider previous = EMFCompareRCPUIPlugin.this.groupProviderRegistry.add(provider);
                                if (previous == null) break;
                                EMFCompareRCPUIPlugin.this.log(2, "The provider '" + provider.getClass().getName() + "' is registered twice.");
                            }
                            catch (CoreException e) {
                                this.logError(element, e.getMessage());
                            }
                            break;
                        }
                        case REMOVE: {
                            EMFCompareRCPUIPlugin.this.groupProviderRegistry.remove(element.getAttribute(ATT_CLASS));
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String string) {
            EMFCompareRCPUIPlugin.this.log(4, string);
        }
    }

    private class FilterExtensionRegistryListener
    extends AbstractRegistryEventListener {
        static final String TAG_FILTER_ACTION = "filter";
        static final String ATT_CLASS = "class";
        static final String ATT_LABEL = "label";
        static final String ATT_ACTIVE = "activeByDefault";

        public FilterExtensionRegistryListener(String pluginID, String extensionPointID) {
            super(pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action b) {
            if (element.getName().equals(TAG_FILTER_ACTION)) {
                if (element.getAttribute(ATT_CLASS) == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                } else if (element.getAttribute(ATT_LABEL) == null) {
                    this.logMissingAttribute(element, ATT_LABEL);
                } else if (element.getAttribute(ATT_ACTIVE) == null) {
                    this.logMissingAttribute(element, ATT_ACTIVE);
                } else {
                    switch (b) {
                        case ADD: {
                            try {
                                IDifferenceFilter filter = (IDifferenceFilter)element.createExecutableExtension(ATT_CLASS);
                                filter.setLabel(element.getAttribute(ATT_LABEL));
                                if (Boolean.valueOf(element.getAttribute(ATT_ACTIVE)).booleanValue()) {
                                    filter.setDefaultSelected(true);
                                } else {
                                    filter.setDefaultSelected(false);
                                }
                                IDifferenceFilter previous = EMFCompareRCPUIPlugin.this.filterRegistry.add(filter);
                                if (previous == null) break;
                                EMFCompareRCPUIPlugin.this.log(2, "The filter '" + filter.getClass().getName() + "' is registered twice.");
                            }
                            catch (CoreException e) {
                                this.logError(element, e.getMessage());
                            }
                            break;
                        }
                        case REMOVE: {
                            EMFCompareRCPUIPlugin.this.filterRegistry.remove(element.getAttribute(ATT_CLASS));
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String string) {
            EMFCompareRCPUIPlugin.this.log(4, string);
        }
    }
}

